/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.api.common.blockentity.IStorageAccessor;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.klikli_dev.occultism.api.common.container.IItemStackComparator;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.api.common.data.SortDirection;
import com.klikli_dev.occultism.api.common.data.SortType;
import com.klikli_dev.occultism.common.block.storage.StorageStabilizerBlock;
import com.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.misc.DepositOrder;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.common.misc.ItemStackKey;
import com.klikli_dev.occultism.common.misc.StorageControllerMapItemStackHandler;
import com.klikli_dev.occultism.network.messages.MessageUpdateStacks;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StorageControllerBlockEntity
extends NetworkedBlockEntity
implements MenuProvider,
IStorageController,
IStorageAccessor,
IStorageControllerProxy,
GeoBlockEntity {
    public static final int MAX_STABILIZER_DISTANCE = 5;
    protected static final List<DeferredBlock<? extends Block>> BLOCK_BLACKLIST = Stream.of(OccultismBlocks.STORAGE_CONTROLLER, OccultismBlocks.STORAGE_CONTROLLER_STABILIZED).collect(Collectors.toList());
    private final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Map<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
    public ItemStack orderStack = ItemStack.EMPTY;
    public Map<GlobalBlockPos, MachineReference> linkedMachines = new HashMap<GlobalBlockPos, MachineReference>();
    public Map<GlobalBlockPos, UUID> depositOrderSpirits = new HashMap<GlobalBlockPos, UUID>();
    public StorageControllerMapItemStackHandler itemStackHandler;
    protected SortDirection sortDirection;
    protected SortType sortType;
    protected int maxItemTypes;
    protected int usedItemTypes;
    protected long maxTotalItemCount;
    protected long usedTotalItemCount;
    protected boolean stabilizersInitialized;
    protected GlobalBlockPos globalPos;
    protected MessageUpdateStacks cachedMessageUpdateStacks;

    public StorageControllerBlockEntity(BlockPos worldPos, BlockState state) {
        super(OccultismBlockEntities.STORAGE_CONTROLLER.get(), worldPos, state);
        this.itemStackHandler = new StorageControllerMapItemStackHandler(this, (Integer)Occultism.SERVER_CONFIG.storage.controllerMaxItemTypes.get(), (Long)Occultism.SERVER_CONFIG.storage.controllerMaxTotalItemCount.get());
        this.sortDirection = SortDirection.DOWN;
        this.sortType = SortType.AMOUNT;
        this.maxItemTypes = (Integer)Occultism.SERVER_CONFIG.storage.controllerMaxItemTypes.get();
        this.usedItemTypes = 0;
        this.maxTotalItemCount = (Long)Occultism.SERVER_CONFIG.storage.controllerMaxTotalItemCount.get();
        this.usedTotalItemCount = 0L;
        this.stabilizersInitialized = false;
    }

    public void tick() {
        if (!this.level.isClientSide && !this.stabilizersInitialized) {
            this.stabilizersInitialized = true;
            this.updateStabilizers();
        }
    }

    public void updateStabilizers() {
        int additionalMaxItemTypes = 0;
        long additionalTotalItemCount = 0L;
        List<BlockPos> stabilizerLocations = this.findValidStabilizers();
        if (this.getBlockState().getBlock().equals(OccultismBlocks.STORAGE_CONTROLLER.get())) {
            for (BlockPos pos : stabilizerLocations) {
                additionalMaxItemTypes += this.getAdditionalMaxItemTypesForStabilizer(this.level.getBlockState(pos));
                additionalTotalItemCount += this.getAdditionalMaxTotalItemCountForStabilizer(this.level.getBlockState(pos));
            }
            this.setStorageLimits((Integer)Occultism.SERVER_CONFIG.storage.controllerMaxItemTypes.get() + additionalMaxItemTypes, (Long)Occultism.SERVER_CONFIG.storage.controllerMaxTotalItemCount.get() + additionalTotalItemCount);
        } else {
            this.setStorageLimits((Integer)Occultism.SERVER_CONFIG.storage.controllerMaxItemTypes.get() + (Integer)Occultism.SERVER_CONFIG.storage.stabilizedControllerStabilizers.get() * (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier4AdditionalMaxItemTypes.get(), (Long)Occultism.SERVER_CONFIG.storage.controllerMaxTotalItemCount.get() + (long)((Integer)Occultism.SERVER_CONFIG.storage.stabilizedControllerStabilizers.get()).intValue() * (Long)Occultism.SERVER_CONFIG.storage.stabilizerTier4AdditionalMaxTotalItemCount.get());
        }
    }

    public List<BlockPos> findValidStabilizers() {
        ArrayList<BlockPos> validStabilizers = new ArrayList<BlockPos>();
        BlockPos up = this.getBlockPos().above();
        for (Direction face : Direction.values()) {
            BlockState state;
            BlockPos hit = Math3DUtil.simpleTrace(up, face, 5, pos -> {
                BlockState state = this.level.getBlockState(pos);
                return state.getBlock() instanceof StorageStabilizerBlock;
            });
            if (hit == null || (state = this.level.getBlockState(hit)).getValue((Property)DirectionalBlock.FACING) != face.getOpposite()) continue;
            validStabilizers.add(hit);
        }
        return validStabilizers;
    }

    protected int getAdditionalMaxItemTypesForStabilizer(BlockState state) {
        Block block = state.getBlock();
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER1.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier1AdditionalMaxItemTypes.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER2.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier2AdditionalMaxItemTypes.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER3.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier3AdditionalMaxItemTypes.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER4.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier4AdditionalMaxItemTypes.get();
        }
        return 0;
    }

    protected long getAdditionalMaxTotalItemCountForStabilizer(BlockState state) {
        Block block = state.getBlock();
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER1.get()) {
            return (Long)Occultism.SERVER_CONFIG.storage.stabilizerTier1AdditionalMaxTotalItemCount.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER2.get()) {
            return (Long)Occultism.SERVER_CONFIG.storage.stabilizerTier2AdditionalMaxTotalItemCount.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER3.get()) {
            return (Long)Occultism.SERVER_CONFIG.storage.stabilizerTier3AdditionalMaxTotalItemCount.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER4.get()) {
            return (Long)Occultism.SERVER_CONFIG.storage.stabilizerTier4AdditionalMaxTotalItemCount.get();
        }
        return 0L;
    }

    protected void validateLinkedMachines() {
        this.linkedMachines.entrySet().removeIf(entry -> !((MachineReference)entry.getValue()).isValidFor(this.level));
    }

    private List<Predicate<ItemStack>> getComparatorsSortedByAmount(Predicate<ItemStack> comparator) {
        StorageControllerMapItemStackHandler handler = this.itemStackHandler;
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack getStackInSlot = handler.getStackInSlot(i);
            if (!comparator.test(getStackInSlot)) continue;
            Integer oldCount = map.getOrDefault(getStackInSlot.getItem(), 0);
            map.put(getStackInSlot.getItem(), oldCount + getStackInSlot.getCount());
        }
        return map.entrySet().stream().sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).map(entry -> stack -> stack.getItem() == entry.getKey()).toList();
    }

    private <E extends GeoBlockEntity> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(RawAnimation.begin().thenLoop("animation.dimensional_matrix.new"));
        return PlayState.CONTINUE;
    }

    public static CompoundTag saveMatrix(Map<Integer, ItemStack> matrix, HolderLookup.Provider provider) {
        CompoundTag matrixCompound = new CompoundTag();
        ListTag matrixNbt = new ListTag();
        for (int i = 0; i < 9; ++i) {
            if (matrix.get(i) == null || matrix.get(i).isEmpty()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.putByte("slot", (byte)i);
            stackTag.put("stack", matrix.get(i).save(provider));
            matrixNbt.add((Object)stackTag);
        }
        matrixCompound.put("matrix", (Tag)matrixNbt);
        return matrixCompound;
    }

    public static Map<Integer, ItemStack> loadMatrix(CompoundTag matrixCompound, HolderLookup.Provider provider) {
        HashMap<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
        if (matrixCompound.contains("matrix")) {
            ListTag matrixNbt = matrixCompound.getList("matrix", 10);
            for (int i = 0; i < matrixNbt.size(); ++i) {
                CompoundTag stackTag = matrixNbt.getCompound(i);
                byte slot = stackTag.getByte("slot");
                ItemStack s = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)stackTag.getCompound("stack"));
                matrix.put(Integer.valueOf(slot), s);
            }
        }
        return matrix;
    }

    public Component getDisplayName() {
        return Component.literal((String)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()).getPath());
    }

    @Override
    public IStorageController getLinkedStorageController() {
        return this;
    }

    @Override
    public GlobalBlockPos getLinkedStorageControllerPosition() {
        if (this.globalPos == null) {
            this.globalPos = new GlobalBlockPos(this.getBlockPos(), this.level);
        }
        return this.globalPos;
    }

    @Override
    public void setLinkedStorageControllerPosition(GlobalBlockPos blockPos) {
    }

    @Override
    public Map<Integer, ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public ItemStack getOrderStack() {
        return this.orderStack;
    }

    @Override
    public void setOrderStack(@Nonnull ItemStack stack) {
        this.orderStack = stack;
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Override
    public SortType getSortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(this.itemStackHandler.getSlots());
        for (Object2IntMap.Entry entry : this.itemStackHandler.keyToCountMap().object2IntEntrySet()) {
            result.add(((ItemStackKey)entry.getKey()).stack().copyWithCount(entry.getIntValue()));
        }
        this.usedItemTypes = this.itemStackHandler.keyToCountMap().size();
        this.usedTotalItemCount = this.itemStackHandler.totalItemCount();
        return result;
    }

    @Override
    public MessageUpdateStacks getMessageUpdateStacks() {
        if (this.cachedMessageUpdateStacks == null) {
            List<ItemStack> stacks = this.getStacks();
            this.cachedMessageUpdateStacks = new MessageUpdateStacks(stacks, this.maxItemTypes, this.usedItemTypes, this.maxTotalItemCount, this.usedTotalItemCount, this.level.registryAccess());
        }
        return this.cachedMessageUpdateStacks;
    }

    @Override
    public int getMaxItemTypes() {
        return this.maxItemTypes;
    }

    @Override
    public void setStorageLimits(int maxItemTypes, long maxTotalItemCount) {
        this.maxItemTypes = maxItemTypes;
        this.maxTotalItemCount = maxTotalItemCount;
        this.itemStackHandler.maxItemTypes(this.maxItemTypes);
        this.itemStackHandler.maxTotalItemCount(this.maxTotalItemCount);
        this.cachedMessageUpdateStacks = null;
        this.markNetworkDirty();
    }

    @Override
    public int getUsedItemTypes() {
        return this.usedItemTypes;
    }

    @Override
    public Map<GlobalBlockPos, MachineReference> getLinkedMachines() {
        return this.linkedMachines;
    }

    @Override
    public void setLinkedMachines(Map<GlobalBlockPos, MachineReference> machines) {
        this.linkedMachines = machines;
    }

    @Override
    public void linkMachine(MachineReference machine) {
        this.linkedMachines.put(machine.insertGlobalPos, machine);
    }

    @Override
    public void addDepositOrder(GlobalBlockPos linkedMachinePosition, IItemStackComparator comparator, int amount) {
        ItemStack stack = this.getItemStack(comparator, amount, true);
        if (!stack.isEmpty()) {
            UUID spiritUUID = this.depositOrderSpirits.get(linkedMachinePosition);
            if (spiritUUID != null) {
                EntityUtil.getEntityByUuiDGlobal(this.level.getServer(), spiritUUID).filter(SpiritEntity.class::isInstance).map(SpiritEntity.class::cast).ifPresent(spirit -> {
                    Optional<ManageMachineJob> job = spirit.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast);
                    if (job.isPresent()) {
                        job.get().addDepsitOrder(new DepositOrder((ItemStackComparator)comparator, amount));
                    } else {
                        this.removeDepositOrderSpirit(linkedMachinePosition);
                    }
                });
            } else {
                this.removeDepositOrderSpirit(linkedMachinePosition);
            }
        }
    }

    @Override
    public void addDepositOrderSpirit(GlobalBlockPos linkedMachinePosition, UUID spiritId) {
        this.depositOrderSpirits.put(linkedMachinePosition, spiritId);
    }

    @Override
    public void removeDepositOrderSpirit(GlobalBlockPos linkedMachinePosition) {
        this.linkedMachines.remove(linkedMachinePosition);
        this.depositOrderSpirits.remove(linkedMachinePosition);
    }

    @Override
    public boolean isBlacklisted(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            return BLOCK_BLACKLIST.stream().map(DeferredHolder::get).anyMatch(block -> itemBlock.getBlock() == block);
        }
        return stack.getItem() == OccultismItems.STORAGE_REMOTE.get();
    }

    @Override
    public int insertStack(ItemStack stack, boolean simulate) {
        if (this.isBlacklisted(stack)) {
            return stack.getCount();
        }
        if (this.itemStackHandler.insertItem(stack, true).getCount() < stack.getCount()) {
            stack = this.itemStackHandler.insertItem(stack, simulate);
        }
        return stack.getCount();
    }

    @Override
    public ItemStack getOneOfMostCommonItem(Predicate<ItemStack> comparator, boolean simulate) {
        if (comparator == null) {
            return ItemStack.EMPTY;
        }
        List<Predicate<ItemStack>> comparators = this.getComparatorsSortedByAmount(comparator);
        for (Predicate<ItemStack> currentComparator : comparators) {
            for (int slot = 0; slot < this.itemStackHandler.getSlots(); ++slot) {
                ItemStack stack = this.itemStackHandler.extractItem(slot, 1, true);
                if (stack.isEmpty() || !currentComparator.test(stack)) continue;
                return this.itemStackHandler.extractItem(slot, 1, simulate);
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack getItemStack(Predicate<ItemStack> comparator, int requestedSize, boolean simulate) {
        ItemStackComparator itemStackComparator;
        if (requestedSize <= 0 || comparator == null) {
            return ItemStack.EMPTY;
        }
        if (comparator instanceof ItemStackComparator && (itemStackComparator = (ItemStackComparator)comparator).getMatchNbt()) {
            return this.itemStackHandler.extractItem(itemStackComparator.getFilterStack(), requestedSize, simulate);
        }
        ItemStack firstMatchedStack = ItemStack.EMPTY;
        int remaining = requestedSize;
        for (int slot = 0; slot < this.itemStackHandler.getSlots(); ++slot) {
            ItemStack stack = this.itemStackHandler.extractItem(slot, remaining, true);
            if (stack.isEmpty()) continue;
            if (firstMatchedStack.isEmpty()) {
                if (!comparator.test(stack)) continue;
                firstMatchedStack = stack.copy();
            } else if (!ItemStack.isSameItemSameComponents((ItemStack)firstMatchedStack, (ItemStack)stack)) continue;
            int toExtract = Math.min(stack.getCount(), remaining);
            ItemStack extractedStack = this.itemStackHandler.extractItem(slot, toExtract, simulate);
            if ((remaining -= extractedStack.getCount()) <= 0) break;
        }
        int extractCount = requestedSize - remaining;
        if (!firstMatchedStack.isEmpty() && extractCount > 0) {
            firstMatchedStack.setCount(extractCount);
        }
        return firstMatchedStack;
    }

    @Override
    public int getAvailableAmount(IItemStackComparator comparator) {
        ItemStackComparator itemStackComparator;
        if (comparator == null) {
            return 0;
        }
        if (comparator instanceof ItemStackComparator && (itemStackComparator = (ItemStackComparator)comparator).getMatchNbt()) {
            return this.itemStackHandler.get(itemStackComparator.getFilterStack());
        }
        int totalCount = 0;
        int size = this.itemStackHandler.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(slot);
            if (!comparator.matches(stack)) continue;
            totalCount += stack.getCount();
        }
        return totalCount;
    }

    @Override
    public void onContentsChanged() {
        this.cachedMessageUpdateStacks = null;
        this.setChanged();
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.remove("linkedMachines");
        super.loadAdditional(compound, provider);
        if (compound.contains("items")) {
            this.itemStackHandler.deserializeNBT(provider, compound.getCompound("items"));
            this.cachedMessageUpdateStacks = null;
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.remove("linkedMachines");
        compound.put("items", (Tag)this.itemStackHandler.serializeNBT(provider));
    }

    @Override
    public void loadNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        this.setSortDirection(SortDirection.BY_ID.apply(compound.getInt("sortDirection")));
        this.setSortType(SortType.BY_ID.apply(compound.getInt("sortType")));
        if (compound.contains("maxItemTypes") && compound.contains("maxTotalItemCount")) {
            this.setStorageLimits(compound.getInt("maxItemTypes"), compound.getLong("maxTotalItemCount"));
        }
        if (compound.contains("matrix")) {
            this.matrix = StorageControllerBlockEntity.loadMatrix(compound.getCompound("matrix"), provider);
        }
        if (compound.contains("orderStack")) {
            this.orderStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("orderStack"));
        }
        this.linkedMachines = new HashMap<GlobalBlockPos, MachineReference>();
        if (compound.contains("linkedMachines")) {
            ListTag machinesNbt = compound.getList("linkedMachines", 10);
            for (int i = 0; i < machinesNbt.size(); ++i) {
                MachineReference reference = (MachineReference)MachineReference.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)machinesNbt.getCompound(i)).getOrThrow();
                this.linkedMachines.put(reference.insertGlobalPos, reference);
            }
        }
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound, HolderLookup.Provider provider) {
        compound.putInt("sortDirection", this.getSortDirection().ordinal());
        compound.putInt("sortType", this.getSortType().ordinal());
        compound.putInt("maxItemTypes", this.maxItemTypes);
        compound.putLong("maxTotalItemCount", this.maxTotalItemCount);
        compound.put("matrix", (Tag)StorageControllerBlockEntity.saveMatrix(this.matrix, provider));
        if (!this.orderStack.isEmpty()) {
            compound.put("orderStack", this.orderStack.saveOptional(provider));
        }
        ListTag machinesNbt = new ListTag();
        for (Map.Entry<GlobalBlockPos, MachineReference> entry : this.linkedMachines.entrySet()) {
            machinesNbt.add((Object)entry.getValue().serializeNBT(provider));
        }
        compound.put("linkedMachines", (Tag)machinesNbt);
        return compound;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        if (pComponentInput.get(OccultismDataComponents.SORT_DIRECTION) != null) {
            this.sortDirection = (SortDirection)((Object)pComponentInput.get(OccultismDataComponents.SORT_DIRECTION));
        }
        if (pComponentInput.get(OccultismDataComponents.SORT_TYPE) != null) {
            this.sortType = (SortType)((Object)pComponentInput.get(OccultismDataComponents.SORT_TYPE));
        }
        if (pComponentInput.get(OccultismDataComponents.CRAFTING_MATRIX) != null) {
            this.matrix = StorageControllerBlockEntity.loadMatrix(((CustomData)pComponentInput.get(OccultismDataComponents.CRAFTING_MATRIX)).getUnsafe(), (HolderLookup.Provider)this.level.registryAccess());
        }
        if (pComponentInput.get(OccultismDataComponents.ORDER_STACK) != null) {
            this.orderStack = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CustomData)pComponentInput.get(OccultismDataComponents.ORDER_STACK)).getUnsafe());
        }
        if (pComponentInput.get((DataComponentType)OccultismDataComponents.STORAGE_CONTROLLER_CONTENTS.get()) != null) {
            this.itemStackHandler.deserializeNBT((HolderLookup.Provider)this.level.registryAccess(), ((CustomData)pComponentInput.get((DataComponentType)OccultismDataComponents.STORAGE_CONTROLLER_CONTENTS.get())).getUnsafe());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        pComponents.set(OccultismDataComponents.SORT_DIRECTION, (Object)this.sortDirection);
        pComponents.set(OccultismDataComponents.SORT_TYPE, (Object)this.sortType);
        pComponents.set(OccultismDataComponents.CRAFTING_MATRIX, (Object)CustomData.of((CompoundTag)StorageControllerBlockEntity.saveMatrix(this.matrix, (HolderLookup.Provider)this.level.registryAccess())));
        pComponents.set(OccultismDataComponents.ORDER_STACK, (Object)CustomData.of((CompoundTag)((CompoundTag)this.orderStack.saveOptional((HolderLookup.Provider)this.level.registryAccess()))));
        pComponents.set(OccultismDataComponents.STORAGE_CONTROLLER_CONTENTS, (Object)CustomData.of((CompoundTag)this.itemStackHandler.serializeNBT((HolderLookup.Provider)this.level.registryAccess())));
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new StorageControllerContainer(id, playerInventory, this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

