/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.blockentity.StableWormholeBlockEntity;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.klikli_dev.occultism.registry.OccultismBlockEntities;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StableWormholeBlock
extends Block
implements EntityBlock {
    public static final Property<Boolean> LINKED = BooleanProperty.create((String)"linked");
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.EAST, (Object)Stream.of(Block.box((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0), Block.box((double)0.0, (double)4.0, (double)1.0, (double)1.0, (double)12.0, (double)4.0), Block.box((double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0, (double)15.0), Block.box((double)0.0, (double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)1.0), Block.box((double)0.0, (double)6.0, (double)15.0, (double)1.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)12.0, (double)1.0, (double)4.0, (double)13.0), Block.box((double)0.0, (double)12.0, (double)12.0, (double)1.0, (double)14.0, (double)13.0), Block.box((double)0.0, (double)2.0, (double)3.0, (double)1.0, (double)4.0, (double)4.0), Block.box((double)0.0, (double)3.0, (double)2.0, (double)1.0, (double)4.0, (double)3.0), Block.box((double)0.0, (double)12.0, (double)2.0, (double)1.0, (double)13.0, (double)3.0), Block.box((double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)4.0, (double)14.0), Block.box((double)0.0, (double)12.0, (double)13.0, (double)1.0, (double)13.0, (double)14.0), Block.box((double)0.0, (double)12.0, (double)3.0, (double)1.0, (double)14.0, (double)4.0), Block.box((double)0.0, (double)1.0, (double)4.0, (double)1.0, (double)4.0, (double)12.0), Block.box((double)0.0, (double)12.0, (double)4.0, (double)1.0, (double)15.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)1.0, (double)10.0), Block.box((double)0.0, (double)15.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).put((Object)Direction.WEST, (Object)Stream.of(Block.box((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.box((double)15.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0), Block.box((double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0), Block.box((double)15.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0), Block.box((double)15.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)15.0, (double)2.0, (double)12.0, (double)16.0, (double)4.0, (double)13.0), Block.box((double)15.0, (double)12.0, (double)12.0, (double)16.0, (double)14.0, (double)13.0), Block.box((double)15.0, (double)2.0, (double)3.0, (double)16.0, (double)4.0, (double)4.0), Block.box((double)15.0, (double)3.0, (double)2.0, (double)16.0, (double)4.0, (double)3.0), Block.box((double)15.0, (double)12.0, (double)2.0, (double)16.0, (double)13.0, (double)3.0), Block.box((double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)4.0, (double)14.0), Block.box((double)15.0, (double)12.0, (double)13.0, (double)16.0, (double)13.0, (double)14.0), Block.box((double)15.0, (double)12.0, (double)3.0, (double)16.0, (double)14.0, (double)4.0), Block.box((double)15.0, (double)1.0, (double)4.0, (double)16.0, (double)4.0, (double)12.0), Block.box((double)15.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0, (double)12.0), Block.box((double)15.0, (double)0.0, (double)6.0, (double)16.0, (double)1.0, (double)10.0), Block.box((double)15.0, (double)15.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).put((Object)Direction.NORTH, (Object)Stream.of(Block.box((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0), Block.box((double)1.0, (double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0), Block.box((double)12.0, (double)4.0, (double)15.0, (double)15.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)6.0, (double)15.0, (double)1.0, (double)10.0, (double)16.0), Block.box((double)15.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)12.0, (double)2.0, (double)15.0, (double)13.0, (double)4.0, (double)16.0), Block.box((double)12.0, (double)12.0, (double)15.0, (double)13.0, (double)14.0, (double)16.0), Block.box((double)3.0, (double)2.0, (double)15.0, (double)4.0, (double)4.0, (double)16.0), Block.box((double)2.0, (double)3.0, (double)15.0, (double)3.0, (double)4.0, (double)16.0), Block.box((double)2.0, (double)12.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0), Block.box((double)13.0, (double)3.0, (double)15.0, (double)14.0, (double)4.0, (double)16.0), Block.box((double)13.0, (double)12.0, (double)15.0, (double)14.0, (double)13.0, (double)16.0), Block.box((double)3.0, (double)12.0, (double)15.0, (double)4.0, (double)14.0, (double)16.0), Block.box((double)4.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0, (double)16.0), Block.box((double)4.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0, (double)16.0), Block.box((double)6.0, (double)0.0, (double)15.0, (double)10.0, (double)1.0, (double)16.0), Block.box((double)6.0, (double)15.0, (double)15.0, (double)10.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).put((Object)Direction.SOUTH, (Object)Stream.of(Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0), Block.box((double)1.0, (double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0), Block.box((double)12.0, (double)4.0, (double)0.0, (double)15.0, (double)12.0, (double)1.0), Block.box((double)0.0, (double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)1.0), Block.box((double)15.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0), Block.box((double)12.0, (double)2.0, (double)0.0, (double)13.0, (double)4.0, (double)1.0), Block.box((double)12.0, (double)12.0, (double)0.0, (double)13.0, (double)14.0, (double)1.0), Block.box((double)3.0, (double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)1.0), Block.box((double)2.0, (double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)1.0), Block.box((double)2.0, (double)12.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0), Block.box((double)13.0, (double)3.0, (double)0.0, (double)14.0, (double)4.0, (double)1.0), Block.box((double)13.0, (double)12.0, (double)0.0, (double)14.0, (double)13.0, (double)1.0), Block.box((double)3.0, (double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)1.0), Block.box((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)1.0), Block.box((double)4.0, (double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)1.0), Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)1.0, (double)1.0), Block.box((double)6.0, (double)15.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).put((Object)Direction.UP, (Object)Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)1.0, (double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0), Block.box((double)12.0, (double)0.0, (double)4.0, (double)15.0, (double)1.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)1.0, (double)10.0), Block.box((double)15.0, (double)0.0, (double)6.0, (double)16.0, (double)1.0, (double)10.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)13.0, (double)1.0, (double)14.0), Block.box((double)12.0, (double)0.0, (double)2.0, (double)13.0, (double)1.0, (double)4.0), Block.box((double)3.0, (double)0.0, (double)12.0, (double)4.0, (double)1.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)12.0, (double)3.0, (double)1.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)4.0), Block.box((double)13.0, (double)0.0, (double)12.0, (double)14.0, (double)1.0, (double)13.0), Block.box((double)13.0, (double)0.0, (double)3.0, (double)14.0, (double)1.0, (double)4.0), Block.box((double)3.0, (double)0.0, (double)2.0, (double)4.0, (double)1.0, (double)4.0), Block.box((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0, (double)15.0), Block.box((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)1.0, (double)4.0), Block.box((double)6.0, (double)0.0, (double)15.0, (double)10.0, (double)1.0, (double)16.0), Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)1.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).put((Object)Direction.DOWN, (Object)Stream.of(Block.box((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)1.0, (double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0), Block.box((double)12.0, (double)15.0, (double)4.0, (double)15.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)15.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0), Block.box((double)15.0, (double)15.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), Block.box((double)12.0, (double)15.0, (double)12.0, (double)13.0, (double)16.0, (double)14.0), Block.box((double)12.0, (double)15.0, (double)2.0, (double)13.0, (double)16.0, (double)4.0), Block.box((double)3.0, (double)15.0, (double)12.0, (double)4.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)15.0, (double)12.0, (double)3.0, (double)16.0, (double)13.0), Block.box((double)2.0, (double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)4.0), Block.box((double)13.0, (double)15.0, (double)12.0, (double)14.0, (double)16.0, (double)13.0), Block.box((double)13.0, (double)15.0, (double)3.0, (double)14.0, (double)16.0, (double)4.0), Block.box((double)3.0, (double)15.0, (double)2.0, (double)4.0, (double)16.0, (double)4.0), Block.box((double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0, (double)15.0), Block.box((double)4.0, (double)15.0, (double)1.0, (double)12.0, (double)16.0, (double)4.0), Block.box((double)6.0, (double)15.0, (double)15.0, (double)10.0, (double)16.0, (double)16.0), Block.box((double)6.0, (double)15.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get()).build());

    public StableWormholeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(LINKED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)BlockStateProperties.FACING));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        StableWormholeBlockEntity wormhole;
        BlockEntity blockEntity;
        if (((Boolean)Occultism.SERVER_CONFIG.storage.unlinkWormholeOnBreak.get()).booleanValue() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof StableWormholeBlockEntity && (wormhole = (StableWormholeBlockEntity)blockEntity).getLinkedStorageController() != null) {
            wormhole.setLinkedStorageControllerPosition(null);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof StableWormholeBlockEntity) {
            StableWormholeBlockEntity wormhole = (StableWormholeBlockEntity)blockEntity;
            if (StorageControllerContainerBase.canOpen(pPlayer, pPos)) {
                if (wormhole.getLinkedStorageController() != null && pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    serverPlayer.openMenu((MenuProvider)wormhole, pPos);
                    StorageControllerContainerBase.reserve(pPlayer, pPos);
                } else {
                    pLevel.setBlock(pPos, (BlockState)pState.setValue(LINKED, (Comparable)Boolean.valueOf(false)), 2);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace());
        if (context.getItemInHand().has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            state = (BlockState)state.setValue(LINKED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public ItemStack getCloneItemStack(LevelReader worldIn, BlockPos pos, BlockState state) {
        return BlockEntityUtil.getItemWithNbt(this, worldIn, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LINKED, BlockStateProperties.FACING});
        super.createBlockStateDefinition(builder);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return OccultismBlockEntities.STABLE_WORMHOLE.get().create(blockPos, blockState);
    }
}

