/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.world;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BlackstoneFormation
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState BLACKSTONE = Blocks.BLACKSTONE.defaultBlockState();
    private static final BlockState GILDED_BLACKSTONE = Blocks.GILDED_BLACKSTONE.defaultBlockState();
    private static final BlockState LAVA = Blocks.LAVA.defaultBlockState();

    public BlackstoneFormation(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private boolean isValidGround(BlockState state) {
        return state.is(BlockTags.DIRT) || state.is(Blocks.STONE);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        if (!this.isValidGround(level.getBlockState(origin.below()))) {
            return false;
        }
        int baseRadius = random.nextInt(3) + 3;
        int height = baseRadius / 2 + random.nextInt(3) + 2;
        BlockPos basePosCopy = new BlockPos((Vec3i)origin);
        BlockPos basePos = origin.above();
        for (int currentRadius = baseRadius; currentRadius > 0; currentRadius += random.nextBoolean() ? 1 : 0) {
            boolean hasFloatingBlocks = false;
            for (int dx = -currentRadius; dx <= currentRadius; ++dx) {
                for (int dz = -currentRadius; dz <= currentRadius; ++dz) {
                    if (dx * dx + dz * dz > currentRadius * currentRadius + random.nextInt(2)) continue;
                    BlockPos fillPos = basePos.offset(dx, 0, dz);
                    while (level.isEmptyBlock(fillPos.below()) && fillPos.getY() > level.getMinBuildHeight()) {
                        level.setBlock(fillPos.below(), (double)random.nextFloat() <= 0.1 ? GILDED_BLACKSTONE : BLACKSTONE, 3);
                        fillPos = fillPos.below();
                        hasFloatingBlocks = true;
                    }
                }
            }
            if (!hasFloatingBlocks) break;
            basePos = basePos.below();
        }
        basePos = basePosCopy;
        for (int y = 0; y < height; ++y) {
            int radius = baseRadius - y;
            if (radius <= 0) {
                height = y;
                break;
            }
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = basePos.offset(dx, y, dz);
                    if (dx * dx + dz * dz > radius * radius + random.nextInt(2)) continue;
                    BlockState block = BLACKSTONE;
                    if ((double)random.nextFloat() <= 0.1) {
                        block = GILDED_BLACKSTONE;
                    }
                    level.setBlock(pos, block, 3);
                }
            }
        }
        BlockPos lavaCenter = basePos.above(height - 1);
        for (int dy = 0; dy < 2; ++dy) {
            BlockPos clearPos = lavaCenter.above(dy);
            if (level.getBlockState(clearPos).isAir()) continue;
            level.setBlock(clearPos, Blocks.AIR.defaultBlockState(), 3);
        }
        level.setBlock(lavaCenter, LAVA, 3);
        if (random.nextBoolean()) {
            BlockPos.MutableBlockPos flowStart = lavaCenter.mutable();
            for (int i = 0; i < 3; ++i) {
                BlockPos flowPos = flowStart.offset(random.nextInt(3) - 1, -i, random.nextInt(3) - 1);
                if (!level.isEmptyBlock(flowPos) && !level.getBlockState(flowPos).canBeReplaced()) continue;
                level.setBlock(flowPos, LAVA, 3);
                BlockPos clearAbove = flowPos.above();
                if (level.getBlockState(clearAbove).isAir() || !level.getBlockState(clearAbove).getFluidState().isEmpty()) continue;
                level.setBlock(clearAbove, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        return true;
    }
}

