/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.blocks.prism.AbstractPrismLens;
import alexthw.ars_elemental.common.blocks.prism.AdvancedPrismTile;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChainingPrismLens
extends AbstractPrismLens
implements ICasterTool {
    public ChainingPrismLens(Item.Properties properties) {
        super(properties.component((Supplier)DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster()), "chaining");
    }

    @Override
    public void shoot(ServerLevel world, BlockPos pos, EntityProjectileSpell spell, Vec3 angle) {
        AdvancedPrismTile ap;
        AbstractCaster spellCaster;
        super.shoot(world, pos, spell, angle);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof AdvancedPrismTile && (spellCaster = this.getSpellCaster((ap = (AdvancedPrismTile)blockEntity).getLens())) != null) {
            SpellResolver spellResolver = spell.resolver();
            Spell.Mutable mutable = spellResolver.spell.mutable();
            mutable.add((AbstractSpellPart[])spellCaster.getSpell().mutable().recipe.toArray(AbstractSpellPart[]::new));
            spellResolver.spellContext = spellResolver.spellContext.withSpell(mutable.immutable());
            spellResolver.spell = mutable.immutable();
            int cost = spellResolver.getResolveCost();
            SourceUtil.takeSourceMultipleWithParticles((BlockPos)pos, (Level)world, (int)10, (int)cost);
        }
    }

    @Override
    public boolean canConvert(EntityProjectileSpell projectileSpell, Level level, BlockPos pos) {
        AdvancedPrismTile ap;
        AbstractCaster spellCaster;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AdvancedPrismTile && (spellCaster = this.getSpellCaster((ap = (AdvancedPrismTile)blockEntity).getLens())) != null) {
            Spell.Mutable mutable = projectileSpell.resolver().spell.mutable();
            mutable.add((AbstractSpellPart[])spellCaster.getSpell().mutable().recipe.toArray(AbstractSpellPart[]::new));
            List validationErrors = ArsNouveauAPI.getInstance().getSpellCraftingSpellValidator().validate(mutable.recipe);
            int manaCost = mutable.immutable().getCost();
            return mutable.recipe.size() < (Integer)ConfigHandler.Common.CHAIN_LENS_LIMIT.get() && validationErrors.isEmpty() && SourceUtil.hasSourceNearby((BlockPos)pos, (Level)level, (int)10, (int)manaCost);
        }
        return false;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        stack.addToTooltip((Supplier)DataComponentRegistry.SPELL_CASTER, context, tooltip2::add, flagIn);
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        if (caster != null && ((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !Screen.hasShiftDown() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }

    @Override
    public void addTooltip(List<Component> tooltip, ItemStack lensStack) {
        AbstractCaster spellCaster = this.getSpellCaster(lensStack);
        if (spellCaster != null && !spellCaster.isSpellHidden()) {
            tooltip.add((Component)Component.literal((String)"Adding glyphs: "));
            if (!spellCaster.getSpellName().isEmpty()) {
                tooltip.add((Component)Component.literal((String)spellCaster.getSpellName()));
            }
            tooltip.add((Component)Component.literal((String)spellCaster.getSpell().getDisplayString()));
        }
    }
}

