/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.api.spell_style;

import alexthw.ars_elemental.ArsNouveauRegistry;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleDensityProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ParticleTypeProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.WallProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GravityWellMotion
extends ParticleMotion {
    public static MapCodec<GravityWellMotion> CODEC = GravityWellMotion.buildPropCodec(GravityWellMotion::new);
    public static StreamCodec<RegistryFriendlyByteBuf, GravityWellMotion> STREAM = GravityWellMotion.buildStreamCodec(GravityWellMotion::new);

    public GravityWellMotion(PropMap propertyMap) {
        super(propertyMap);
    }

    public GravityWellMotion() {
        this(new PropMap());
    }

    public void tick(PropertyParticleOptions particleOptions, Level level, double x, double y, double z, double prevX, double prevY, double prevZ) {
        ParticleDensityProperty density = this.getDensity(particleOptions, 20, 0.0f);
        WallProperty wallProperty = (WallProperty)particleOptions.map.getOrDefault((IPropertyType)ParticlePropertyRegistry.WALL_PROPERTY.get(), (BaseProperty)new WallProperty(5, 5, 20, Direction.NORTH));
        RandomSource rand = level.random;
        Vec3 centerVec = new Vec3(x + 0.5, y + 1.0, z + 0.5);
        double radius = wallProperty.range;
        ParticleMotion.SpawnType spawnType = density.spawnType().orElse(ParticleMotion.SpawnType.SPHERE);
        for (int i = 0; i < density.density(); ++i) {
            if (rand.nextInt(wallProperty.chance) != 0) continue;
            Vec3 spawnPos = this.getMotionScaled(centerVec, radius, spawnType);
            Vec3 toCenter = centerVec.subtract(spawnPos).scale(0.05);
            level.addAlwaysVisibleParticle((ParticleOptions)particleOptions, true, spawnPos.x, spawnPos.y, spawnPos.z, toCenter.x, toCenter.y, toCenter.z);
        }
    }

    public IParticleMotionType<?> getType() {
        return (IParticleMotionType)ArsNouveauRegistry.GRAVITY_FIELD_TYPE.get();
    }

    public List<BaseProperty<?>> getProperties(PropMap propMap) {
        return List.of(propMap.createIfMissing((BaseProperty)new ParticleTypeProperty()), propMap.createIfMissing((BaseProperty)new ParticleDensityProperty().minDensity(20).maxDensity(100).densityStepSize(10).supportsShapes(false)));
    }
}

