/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.api.item;

import alexthw.ars_elemental.common.items.armor.AAMaterials;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.setup.registry.MaterialRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public interface IElementalArmor
extends ISpellModifierItem {
    public static final Map<SpellSchool, TagKey<DamageType>> damageResistances = new ConcurrentHashMap<SpellSchool, TagKey<DamageType>>();

    public static Holder<ArmorMaterial> schoolToMaterial(SpellSchool element) {
        return switch (element.getId()) {
            case "fire" -> AAMaterials.fire;
            case "air" -> AAMaterials.air;
            case "earth" -> AAMaterials.earth;
            case "water" -> AAMaterials.water;
            default -> MaterialRegistry.MEDIUM;
        };
    }

    default public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        if (this.getSchool().isPartOfSchool(spellPart)) {
            builder.addAmplification(0.5);
        }
        return builder;
    }

    default public double getDiscount(List<AbstractSpellPart> recipe) {
        double sum = 0.0;
        for (AbstractSpellPart part : recipe) {
            if (!this.getSchool().isPartOfSchool(part)) continue;
            sum += 0.2 * (double)part.getCastingCost();
        }
        return sum;
    }

    public SpellSchool getSchool();

    public String getTier();

    default public boolean doAbsorb(DamageSource damageSource) {
        return damageResistances.containsKey(this.getSchool()) && damageSource.is(damageResistances.get(this.getSchool()));
    }

    default public boolean fillAbsorptions(DamageSource damageSource, HashMap<SpellSchool, Integer> bonusMap) {
        if (this.doAbsorb(damageSource)) {
            bonusMap.put(this.getSchool(), bonusMap.getOrDefault(this.getSchool(), 0) + 1);
            return true;
        }
        return false;
    }
}

