/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.world.feature;

import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class SoulstoneFeature
extends Feature<OreConfiguration> {
    public SoulstoneFeature(Codec<OreConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<OreConfiguration> context) {
        RandomSource random = context.random();
        OreConfiguration config = (OreConfiguration)context.config();
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        float f = random.nextFloat() * (float)Math.PI;
        float f1 = (float)config.size / 8.0f;
        int i = Mth.ceil((float)(((float)config.size / 16.0f * 2.0f + 1.0f) / 2.0f));
        double d0 = (float)pos.getX() + Mth.sin((float)f) * f1;
        double d1 = (float)pos.getX() - Mth.sin((float)f) * f1;
        double d2 = (float)pos.getZ() + Mth.cos((float)f) * f1;
        double d3 = (float)pos.getZ() - Mth.cos((float)f) * f1;
        double d4 = pos.getY() + random.nextInt(3) - 2;
        double d5 = pos.getY() + random.nextInt(3) - 2;
        int k = pos.getX() - Mth.ceil((float)f1) - i;
        int l = pos.getY() - 2 - i;
        int i1 = pos.getZ() - Mth.ceil((float)f1) - i;
        int j1 = 2 * (Mth.ceil((float)f1) + i);
        int k1 = 2 * (2 + i);
        for (int l1 = k; l1 <= k + j1; ++l1) {
            for (int i2 = i1; i2 <= i1 + j1; ++i2) {
                if (l > level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, l1, i2)) continue;
                return this.doPlace((LevelAccessor)level, random, config, d0, d1, d2, d3, d4, d5, k, l, i1, j1, k1);
            }
        }
        return false;
    }

    protected boolean doPlace(LevelAccessor world, RandomSource random, OreConfiguration config, double p_207803_4_, double p_207803_6_, double p_207803_8_, double p_207803_10_, double p_207803_12_, double p_207803_14_, int p_207803_16_, int p_207803_17_, int p_207803_18_, int p_207803_19_, int p_207803_20_) {
        int i = 0;
        BitSet bitset = new BitSet(p_207803_19_ * p_207803_20_ * p_207803_19_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double[] adouble = new double[config.size * 4];
        for (int j = 0; j < config.size; ++j) {
            float f = (float)j / (float)config.size;
            double d0 = Mth.lerp((double)f, (double)p_207803_4_, (double)p_207803_6_);
            double d2 = Mth.lerp((double)f, (double)p_207803_12_, (double)p_207803_14_);
            double d4 = Mth.lerp((double)f, (double)p_207803_8_, (double)p_207803_10_);
            double d6 = random.nextDouble() * (double)config.size / 16.0;
            double d7 = ((double)(Mth.sin((float)((float)Math.PI * f)) + 1.0f) * d6 + 1.0) / 2.0;
            adouble[j * 4 + 0] = d0;
            adouble[j * 4 + 1] = d2;
            adouble[j * 4 + 2] = d4;
            adouble[j * 4 + 3] = d7;
        }
        for (int l2 = 0; l2 < config.size - 1; ++l2) {
            if (adouble[l2 * 4 + 3] <= 0.0) continue;
            for (int j3 = l2 + 1; j3 < config.size; ++j3) {
                double d14;
                double d13;
                double d12;
                double d15;
                if (adouble[j3 * 4 + 3] <= 0.0 || !((d15 = adouble[l2 * 4 + 3] - adouble[j3 * 4 + 3]) * d15 > (d12 = adouble[l2 * 4 + 0] - adouble[j3 * 4 + 0]) * d12 + (d13 = adouble[l2 * 4 + 1] - adouble[j3 * 4 + 1]) * d13 + (d14 = adouble[l2 * 4 + 2] - adouble[j3 * 4 + 2]) * d14)) continue;
                if (d15 > 0.0) {
                    adouble[j3 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[l2 * 4 + 3] = -1.0;
            }
        }
        for (int i3 = 0; i3 < config.size; ++i3) {
            double d11 = adouble[i3 * 4 + 3];
            if (d11 < 0.0) continue;
            double d1 = adouble[i3 * 4 + 0];
            double d3 = adouble[i3 * 4 + 1];
            double d5 = adouble[i3 * 4 + 2];
            int k = Math.max(Mth.floor((double)(d1 - d11)), p_207803_16_);
            int k3 = Math.max(Mth.floor((double)(d3 - d11)), p_207803_17_);
            int l = Math.max(Mth.floor((double)(d5 - d11)), p_207803_18_);
            int i1 = Math.max(Mth.floor((double)(d1 + d11)), k);
            int j1 = Math.max(Mth.floor((double)(d3 + d11)), k3);
            int k1 = Math.max(Mth.floor((double)(d5 + d11)), l);
            for (int l1 = k; l1 <= i1; ++l1) {
                double d8 = ((double)l1 + 0.5 - d1) / d11;
                if (!(d8 * d8 < 1.0)) continue;
                for (int i2 = k3; i2 <= j1; ++i2) {
                    double d9 = ((double)i2 + 0.5 - d3) / d11;
                    if (!(d8 * d8 + d9 * d9 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        int k2;
                        double d10 = ((double)j2 + 0.5 - d5) / d11;
                        if (!(d8 * d8 + d9 * d9 + d10 * d10 < 1.0) || bitset.get(k2 = l1 - p_207803_16_ + (i2 - p_207803_17_) * p_207803_19_ + (j2 - p_207803_18_) * p_207803_19_ * p_207803_20_)) continue;
                        bitset.set(k2);
                        blockpos$mutableblockpos.set(l1, i2, j2);
                        OreConfiguration.TargetBlockState target = config.targetStates.stream().filter(s -> s.target.test(world.getBlockState((BlockPos)blockpos$mutableblockpos), random)).findFirst().orElse(null);
                        if (target == null) continue;
                        if (ModBlocks.SOULIUM_ORE.isBound() && random.nextDouble() < (Double)ModConfigs.SOULIUM_ORE_CHANCE.get()) {
                            world.setBlock((BlockPos)blockpos$mutableblockpos, ((Block)ModBlocks.SOULIUM_ORE.get()).defaultBlockState(), 2);
                        } else {
                            world.setBlock((BlockPos)blockpos$mutableblockpos, target.state, 2);
                        }
                        ++i;
                    }
                }
            }
        }
        return i > 0;
    }
}

