/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class SoulJarItem
extends BaseItem {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");

    public SoulJarItem() {
        super(p -> p.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MobSoulType type = MobSoulUtils.getType(stack);
        if (type != null) {
            Component entityName = type.getEntityDisplayName();
            String souls = DECIMAL_FORMAT.format(MobSoulUtils.getSouls(stack));
            String requirement = DECIMAL_FORMAT.format(type.getSoulRequirement());
            tooltip.add((Component)ModTooltips.SOUL_JAR.args(new Object[]{entityName, souls, requirement}).build());
            if (flag.isAdvanced()) {
                tooltip.add((Component)ModTooltips.MST_ID.args(new Object[]{type.getId().toString()}).color(ChatFormatting.DARK_GRAY).build());
            }
        }
    }

    public static ItemPropertyFunction getFillPropertyGetter() {
        return (stack, world, entity, _unused) -> {
            double souls;
            MobSoulType type = MobSoulUtils.getType(stack);
            if (type != null && (souls = MobSoulUtils.getSouls(stack)) > 0.0) {
                return (int)(souls / type.getSoulRequirement() * 9.0);
            }
            return 0.0f;
        };
    }
}

