/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.config.MaterialBlacklist;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.core.ModContainers;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerFramingTable;
import com.texelsaurus.minecraft.chameleon.inventory.ContentMenuProvider;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockEntityFramingTable
extends BaseBlockEntity
implements Nameable {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_SIDE = 1;
    public static final int SLOT_TRIM = 2;
    public static final int SLOT_FRONT = 3;
    public static final int SLOT_RESULT = 4;
    private final BlockInventory inventory;
    private final MaterialData materialData = new MaterialData();
    protected ItemStack inputStack = ItemStack.EMPTY;
    protected ItemStack resultStack = ItemStack.EMPTY;
    private Component name;

    public BlockEntityFramingTable(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.injectData(this.materialData);
        this.inventory = new BlockInventory(this);
    }

    public BlockEntityFramingTable(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.FRAMING_TABLE.get(), pos, state);
    }

    public static boolean isMaterialSlot(int slotIndex) {
        return slotIndex == 1 || slotIndex == 2 || slotIndex == 3;
    }

    public MaterialData material() {
        return this.materialData;
    }

    public BlockInventory inventory() {
        return this.inventory;
    }

    @Override
    protected void readFixed(HolderLookup.Provider provider, CompoundTag tag) {
        super.readFixed(provider, tag);
        this.inputStack = ItemStack.EMPTY;
        if (tag.contains("Input")) {
            this.inputStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("Input"));
        }
        this.resultStack = ItemStack.EMPTY;
        if (tag.contains("Result")) {
            this.resultStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("Result"));
        }
    }

    @Override
    protected CompoundTag writeFixed(HolderLookup.Provider provider, CompoundTag tag) {
        tag = super.writeFixed(provider, tag);
        if (!this.inputStack.isEmpty()) {
            tag.put("Input", this.inputStack.saveOptional(provider));
        }
        if (!this.resultStack.isEmpty()) {
            tag.put("Result", this.resultStack.saveOptional(provider));
        }
        return tag;
    }

    public boolean isItemValidTarget(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        if (blockItem.getBlock() instanceof IFramedBlock) {
            FrameData data = (FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY);
            if (!data.side().isEmpty() && !this.materialData.getSide().isEmpty()) {
                return false;
            }
            if (!data.trim().isEmpty() && !this.materialData.getTrim().isEmpty()) {
                return false;
            }
            return data.front().isEmpty() || this.materialData.getFront().isEmpty();
        }
        return blockItem.getBlock() instanceof IFramedSourceBlock;
    }

    private boolean testTargetFrameMaterial(ItemStack sourceMat, ItemStack targetMat, int sourceCount, int targetCount) {
        if (sourceMat.isEmpty() || targetMat.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)sourceMat, (ItemStack)targetMat);
    }

    public static boolean isItemValidMaterial(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.getBlock().defaultBlockState();
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.framed.enforceSolidMaterials.get()).booleanValue()) {
            if (state.getBlock().hasDynamicShape()) {
                return false;
            }
            try {
                if (!Block.isShapeFullBlock((VoxelShape)state.getOcclusionShape(null, null))) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (((Boolean)ModCommonConfig.INSTANCE.DRAWERS.framed.enforceOpaqueMaterials.get()).booleanValue() && !state.canOcclude()) {
            return false;
        }
        return !MaterialBlacklist.INSTANCE.isBlacklisted(stack);
    }

    public Component getName() {
        return this.name != null ? this.name : Component.translatable((String)"block.storagedrawers.framing_table");
    }

    public Component getCustomName() {
        return this.name;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.name = (Component)input.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
    }

    @Override
    public void readPortable(HolderLookup.Provider provider, CompoundTag tag) {
        super.readPortable(provider, tag);
        if (tag.contains("CustomName", 8)) {
            this.name = BlockEntityFramingTable.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
    }

    @Override
    public CompoundTag writePortable(HolderLookup.Provider provider, CompoundTag tag) {
        tag = super.writePortable(provider, tag);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
        return tag;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
    }

    public static class BlockInventory
    implements Container {
        private BlockEntityFramingTable entity;

        private BlockInventory(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        public int getContainerSize() {
            return 5;
        }

        public boolean isEmpty() {
            if (!this.entity.inputStack.isEmpty()) {
                return false;
            }
            if (!this.entity.resultStack.isEmpty()) {
                return false;
            }
            if (!this.entity.materialData.getSide().isEmpty()) {
                return false;
            }
            if (!this.entity.materialData.getTrim().isEmpty()) {
                return false;
            }
            return this.entity.materialData.getFront().isEmpty();
        }

        public boolean canPlaceItem(int slotIndex, ItemStack stack) {
            if (slotIndex == 0) {
                return this.entity.isItemValidTarget(stack);
            }
            if (slotIndex == 1 || slotIndex == 2 || slotIndex == 3) {
                return BlockEntityFramingTable.isItemValidMaterial(stack);
            }
            return false;
        }

        public ItemStack getItem(int slot) {
            return switch (slot) {
                case 0 -> this.entity.inputStack;
                case 3 -> this.entity.materialData.getFront();
                case 1 -> this.entity.materialData.getSide();
                case 2 -> this.entity.materialData.getTrim();
                case 4 -> this.entity.resultStack;
                default -> null;
            };
        }

        public ItemStack removeItem(int slot, int amount) {
            if (slot < 0 || slot > this.getContainerSize() || amount <= 0) {
                return ItemStack.EMPTY;
            }
            ItemStack ret = this.getItem(slot).split(amount);
            this.rebuildResult();
            this.setChanged();
            return ret;
        }

        public ItemStack removeItemNoUpdate(int slot) {
            if (slot < 0 || slot > this.getContainerSize()) {
                return ItemStack.EMPTY;
            }
            ItemStack result = this.getItem(slot);
            this.setItem(slot, ItemStack.EMPTY);
            return result;
        }

        public void setItem(int slot, ItemStack stack) {
            if (slot == 4) {
                return;
            }
            switch (slot) {
                case 0: {
                    this.setInputItem(stack);
                    break;
                }
                case 3: {
                    this.entity.materialData.setFront(stack);
                    break;
                }
                case 1: {
                    this.entity.materialData.setSide(stack);
                    break;
                }
                case 2: {
                    this.entity.materialData.setTrim(stack);
                }
            }
            this.setChanged();
        }

        public void setChanged() {
            this.rebuildResult();
            this.entity.setChanged();
        }

        private void setInputItem(ItemStack stack) {
            BlockItem blockItem;
            Block block;
            Item item;
            if (this.entity.level != null && !stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IFramedBlock) {
                IFramedBlock fb = (IFramedBlock)block;
                FrameData data = (FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY);
                if (fb.supportsFrameMaterial(FrameMaterial.SIDE) && !this.entity.materialData.getSide().isEmpty() && !data.side().isEmpty()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.TRIM) && !this.entity.materialData.getTrim().isEmpty() && !data.trim().isEmpty()) {
                    this.entity.resultStack = stack;
                    return;
                }
                if (fb.supportsFrameMaterial(FrameMaterial.FRONT) && !this.entity.materialData.getFront().isEmpty() && !data.front().isEmpty()) {
                    this.entity.resultStack = stack;
                    return;
                }
                ItemStack source = data.base();
                if (!source.isEmpty()) {
                    int count = stack.getCount();
                    this.entity.inputStack = stack.transmuteCopy((ItemLike)source.getItem());
                    this.entity.inputStack.remove((DataComponentType)ModDataComponents.FRAME_DATA.get());
                    this.entity.materialData.setSide(fb.supportsFrameMaterial(FrameMaterial.SIDE) ? data.side().copyWithCount(count) : ItemStack.EMPTY);
                    this.entity.materialData.setTrim(fb.supportsFrameMaterial(FrameMaterial.TRIM) ? data.trim().copyWithCount(count) : ItemStack.EMPTY);
                    this.entity.materialData.setFront(fb.supportsFrameMaterial(FrameMaterial.FRONT) ? data.front().copyWithCount(count) : ItemStack.EMPTY);
                    return;
                }
            }
            this.entity.inputStack = stack;
        }

        private void rebuildResult() {
            BlockItem blockItem;
            Block block;
            Item item;
            ItemStack target = this.getItem(0);
            if (target.isEmpty()) {
                this.entity.resultStack = ItemStack.EMPTY;
                return;
            }
            ItemStack matSide = this.getItem(1);
            ItemStack matTrim = this.getItem(2);
            ItemStack matFront = this.getItem(3);
            if (!target.isEmpty() && (item = target.getItem()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IFramedSourceBlock) {
                IFramedSourceBlock fsb = (IFramedSourceBlock)block;
                this.entity.resultStack = matSide.isEmpty() ? ItemStack.EMPTY : fsb.makeFramedItem(target, matSide, matTrim, matFront);
            }
            int count = this.entity.resultStack.getCount();
            if (!matSide.isEmpty()) {
                count = Math.min(count, matSide.getCount());
            }
            if (!matTrim.isEmpty()) {
                count = Math.min(count, matTrim.getCount());
            }
            if (!matFront.isEmpty()) {
                count = Math.min(count, matFront.getCount());
            }
            this.entity.resultStack.setCount(count);
        }

        public boolean stillValid(Player player) {
            return Container.stillValidBlockEntity((BlockEntity)this.entity, (Player)player);
        }

        public void clearContent() {
            this.entity.inputStack = ItemStack.EMPTY;
            this.entity.resultStack = ItemStack.EMPTY;
            this.entity.materialData.clear();
        }
    }

    public static class ContentProvider
    implements ContentMenuProvider<PositionContent> {
        private BlockEntityFramingTable entity;

        public ContentProvider(BlockEntityFramingTable entity) {
            this.entity = entity;
        }

        @Override
        public PositionContent createContent(ServerPlayer player) {
            return new PositionContent(this.entity.getBlockPos());
        }

        public Component getDisplayName() {
            return this.entity.getDisplayName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return new ContainerFramingTable((MenuType)ModContainers.FRAMING_TABLE.get(), id, inventory, this.entity);
        }
    }
}

