/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.IMatterType;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.tools.PEPickaxe;
import moze_intel.projecte.gameObjs.registries.PEDamageTypes;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import org.jetbrains.annotations.Nullable;

public class ToolHelper {
    private static final ResourceLocation CHARGE_MODIFIER_ID = PECore.rl("charge_modifier");
    public static final ItemAbility HAMMER_DIG = ItemAbility.get((String)"hammer_dig");
    public static final ItemAbility KATAR_DIG = ItemAbility.get((String)"katar_dig");
    public static final ItemAbility MORNING_STAR_DIG = ItemAbility.get((String)"morning_star_dig");
    public static final Set<ItemAbility> DEFAULT_PE_HAMMER_ACTIONS = ToolHelper.of(HAMMER_DIG);
    public static final Set<ItemAbility> DEFAULT_PE_KATAR_ACTIONS = ToolHelper.of(KATAR_DIG);
    public static final Set<ItemAbility> DEFAULT_PE_MORNING_STAR_ACTIONS = ToolHelper.of(MORNING_STAR_DIG);
    private static final Predicate<Entity> SHEARABLE = entity -> !entity.isSpectator() && entity instanceof IShearable;
    private static final Predicate<Entity> SLAY_MOB = entity -> !entity.isSpectator() && entity instanceof Enemy;
    private static final Predicate<Entity> SLAY_ALL = entity -> !entity.isSpectator() && (entity instanceof Enemy || entity instanceof LivingEntity);

    private static Set<ItemAbility> of(ItemAbility ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    @SafeVarargs
    public static InteractionResult performActions(UseOnContext context, BlockState state, InteractionResult firstAction, BiFunction<UseOnContext, BlockState, InteractionResult> ... secondaryActions) {
        if (firstAction.consumesAction()) {
            return firstAction;
        }
        InteractionResult result = firstAction;
        boolean hasFailed = result == InteractionResult.FAIL;
        for (BiFunction<UseOnContext, BlockState, InteractionResult> secondaryAction : secondaryActions) {
            result = secondaryAction.apply(context, state);
            if (result.consumesAction()) {
                return result;
            }
            hasFailed &= result == InteractionResult.FAIL;
        }
        if (hasFailed) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult clearTagAOE(Level level, Player player, InteractionHand hand, ItemStack stack, long emcCost, TagKey<Block> tag) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        int charge = ToolHelper.getCharge(stack);
        if (charge == 0) {
            return InteractionResult.PASS;
        }
        int horizontalRadius = 5 * charge;
        int verticalRadius = 2 * horizontalRadius;
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsInBox(player.getBoundingBox().inflate((double)horizontalRadius, (double)verticalRadius, (double)horizontalRadius))) {
            BlockState state = level.getBlockState(pos);
            if (!state.is(tag)) continue;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!PlayerHelper.hasBreakPermission((ServerPlayer)player, level, pos = pos.immutable())) continue;
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            drops.addAll(Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, pos), (Entity)player, (ItemStack)stack));
            level.removeBlock(pos, false);
            hasAction = true;
            if (level.random.nextInt(5) != 0) continue;
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, player.position());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult dowseCampfire(UseOnContext context, BlockState state) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (state.getBlock() instanceof CampfireBlock && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            if (!level.isClientSide()) {
                level.levelEvent(1009, pos, 0);
            }
            CampfireBlock.dowse((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.FALSE), 11);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult tillAOE(UseOnContext context, BlockState clickedState, long emcCost) {
        return ToolHelper.useAOE(context, clickedState, emcCost, ItemAbilities.HOE_TILL, SoundEvents.HOE_TILL, -1, new HoeToolAOEData());
    }

    public static InteractionResult flattenAOE(UseOnContext context, BlockState clickedState, long emcCost) {
        Direction sideHit = context.getClickedFace();
        if (sideHit == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        return ToolHelper.useAOE(context, clickedState, emcCost, ItemAbilities.SHOVEL_FLATTEN, SoundEvents.SHOVEL_FLATTEN, -1, new ShovelToolAOEData());
    }

    public static InteractionResult stripLogsAOE(UseOnContext context, BlockState clickedState, long emcCost) {
        return ToolHelper.useAxeAOE(context, clickedState, emcCost, ItemAbilities.AXE_STRIP, SoundEvents.AXE_STRIP, -1);
    }

    public static InteractionResult scrapeAOE(UseOnContext context, BlockState clickedState, long emcCost) {
        return ToolHelper.useAxeAOE(context, clickedState, emcCost, ItemAbilities.AXE_SCRAPE, SoundEvents.AXE_SCRAPE, 3005);
    }

    public static InteractionResult waxOffAOE(UseOnContext context, BlockState clickedState, long emcCost) {
        return ToolHelper.useAxeAOE(context, clickedState, emcCost, ItemAbilities.AXE_WAX_OFF, SoundEvents.AXE_WAX_OFF, 3004);
    }

    private static InteractionResult useAxeAOE(UseOnContext context, BlockState clickedState, long emcCost, ItemAbility action, SoundEvent sound, int particle) {
        return ToolHelper.useAOE(context, clickedState, emcCost, action, sound, particle, new AxeToolAOEData());
    }

    private static InteractionResult useAOE(UseOnContext context, BlockState clickedState, long emcCost, ItemAbility action, SoundEvent sound, int particle, IToolAOEData toolAOEData) {
        ItemStack stack;
        int charge;
        BlockPos pos;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        if (!toolAOEData.isValid(level, pos = context.getClickedPos(), clickedState)) {
            return InteractionResult.PASS;
        }
        BlockState modifiedState = clickedState.getToolModifiedState(context, action, false);
        if (modifiedState == null) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, context.getItemInHand());
        level.setBlock(pos, modifiedState, 11);
        level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (particle != -1) {
            level.levelEvent(particle, pos, 0);
        }
        if ((charge = ToolHelper.getCharge(stack = context.getItemInHand())) > 0) {
            Direction side = context.getClickedFace();
            toolAOEData.persistData(level, pos, clickedState, side);
            for (BlockPos newPos : toolAOEData.getTargetPositions(pos, side, charge)) {
                if (pos.equals((Object)newPos)) continue;
                BlockState state = level.getBlockState(newPos);
                UseOnContext adjustedContext = new UseOnContext(level, context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(context.getClickLocation().add((double)(newPos.getX() - pos.getX()), (double)(newPos.getY() - pos.getY()), (double)(newPos.getZ() - pos.getZ())), context.getClickedFace(), newPos, context.isInside()));
                if (!toolAOEData.isValid(level, newPos, state) || modifiedState != state.getToolModifiedState(adjustedContext, action, true)) continue;
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                newPos = newPos.immutable();
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, newPos, context.getItemInHand());
                state.getToolModifiedState(adjustedContext, action, false);
                level.setBlock(newPos, modifiedState, 11);
                if (particle == -1) continue;
                level.levelEvent(particle, newPos, 0);
            }
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.CONSUME;
    }

    public static void digBasedOnMode(ItemStack stack, Level level, BlockPos pos, LivingEntity living, RayTracePointer tracePointer, PEPickaxe.PickaxeMode mode) {
        if (level.isClientSide || mode == PEPickaxe.PickaxeMode.STANDARD || ProjectEConfig.server.items.disableAllRadiusMining.get() || !(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        BlockHitResult result = tracePointer.rayTrace(level, player, ClipContext.Fluid.NONE);
        if (result.getType() == HitResult.Type.MISS || !pos.equals((Object)result.getBlockPos())) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos digPos : ToolHelper.getTargets(pos, player, result.getDirection(), mode)) {
            BlockState state = level.getBlockState(digPos);
            if (state.isAir() || state.getDestroySpeed((BlockGetter)level, digPos) == -1.0f || !stack.isCorrectToolForDrops(state) || !PlayerHelper.hasBreakPermission((ServerPlayer)player, level, digPos = digPos.immutable())) continue;
            drops.addAll(Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)digPos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, digPos), (Entity)player, (ItemStack)stack));
            level.removeBlock(digPos, false);
        }
        WorldHelper.createLootDrop(drops, level, pos);
    }

    private static Iterable<BlockPos> getTargets(BlockPos pos, Player player, Direction sideHit, PEPickaxe.PickaxeMode mode) {
        return switch (mode) {
            case PEPickaxe.PickaxeMode.TALLSHOT -> BlockPos.betweenClosed((BlockPos)pos.below(), (BlockPos)pos.above());
            case PEPickaxe.PickaxeMode.WIDESHOT -> {
                switch (sideHit.getAxis() == Direction.Axis.Y ? player.getDirection().getAxis() : sideHit.getAxis()) {
                    case X: {
                        yield BlockPos.betweenClosed((BlockPos)pos.south(), (BlockPos)pos.north());
                    }
                    case Z: {
                        yield BlockPos.betweenClosed((BlockPos)pos.west(), (BlockPos)pos.east());
                    }
                }
                yield Collections.singleton(pos);
            }
            case PEPickaxe.PickaxeMode.LONGSHOT -> BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.relative(sideHit.getOpposite(), 2));
            default -> Collections.singleton(pos);
        };
    }

    public static InteractionResult digAOE(Level level, Player player, InteractionHand hand, ItemStack stack, BlockPos pos, Direction sideHit, boolean affectDepth, long emcCost) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        int charge = ToolHelper.getCharge(stack);
        if (charge == 0) {
            return InteractionResult.PASS;
        }
        AABB box = affectDepth ? WorldHelper.getBroadDeepBox(pos, sideHit, charge) : WorldHelper.getFlatYBox(pos, charge);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos newPos : WorldHelper.getPositionsInBox(box)) {
            BlockState state = level.getBlockState(newPos);
            if (state.isAir() || state.getDestroySpeed((BlockGetter)level, newPos) == -1.0f || !stack.isCorrectToolForDrops(state)) continue;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!PlayerHelper.hasBreakPermission((ServerPlayer)player, level, newPos = newPos.immutable())) continue;
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            drops.addAll(Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)newPos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, newPos), (Entity)player, (ItemStack)stack));
            level.removeBlock(newPos, false);
            hasAction = true;
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, pos);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.DESTRUCT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void attackWithCharge(ItemStack stack, LivingEntity damaged, LivingEntity damager, float baseDmg) {
        DamageSource dmg;
        Player player;
        block6: {
            block5: {
                if (!(damager instanceof Player)) break block5;
                player = (Player)damager;
                if (!damager.level().isClientSide) break block6;
            }
            return;
        }
        int charge = ToolHelper.getCharge(stack);
        float totalDmg = baseDmg;
        if (charge > 0) {
            dmg = PEDamageTypes.BYPASS_ARMOR_PLAYER_ATTACK.source((LivingEntity)player);
            totalDmg += (float)charge;
        } else {
            dmg = damager.damageSources().playerAttack(player);
        }
        damaged.hurt(dmg, totalDmg);
    }

    public static void attackAOE(ItemStack stack, Player player, boolean slayAll, float damage, long emcCost, InteractionHand hand) {
        Level level = player.level();
        if (level.isClientSide) {
            return;
        }
        int charge = ToolHelper.getCharge(stack);
        List toAttack = level.getEntities((Entity)player, player.getBoundingBox().inflate((double)(2.5f * (float)charge)), slayAll ? SLAY_ALL : SLAY_MOB);
        DamageSource src = PEDamageTypes.BYPASS_ARMOR_PLAYER_ATTACK.source((LivingEntity)player);
        boolean hasAction = false;
        for (Entity entity : toAttack) {
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            entity.hurt(src, damage);
            hasAction = true;
        }
        if (hasAction) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)PESoundEvents.CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            PlayerHelper.swingItem(player, hand);
        }
    }

    public static InteractionResult shearEntityAOE(Player player, InteractionHand hand, long emcCost) {
        Level level = player.level();
        ItemStack stack = player.getItemInHand(hand);
        int offset = (int)Math.pow(2.0, 2 + ToolHelper.getCharge(stack));
        List list = level.getEntitiesOfClass(Entity.class, player.getBoundingBox().inflate((double)offset, (double)offset / 2.0, (double)offset), SHEARABLE);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Entity ent : list) {
            Mob mob;
            Entity e;
            BlockPos entityPosition;
            IShearable target = (IShearable)ent;
            if (target.isShearable(player, stack, level, entityPosition = ent.blockPosition())) {
                if (level.isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                List entDrops = target.onSheared(player, stack, level, entityPosition);
                ent.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                if (!entDrops.isEmpty()) {
                    drops.addAll(entDrops);
                    drops.addAll(entDrops);
                }
                hasAction = true;
            }
            if (level.isClientSide || !(Math.random() < 0.01) || (e = ent.getType().create(level)) == null) continue;
            e.setPos(ent.getX(), ent.getY(), ent.getZ());
            if (e instanceof Mob) {
                mob = (Mob)e;
                EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)((ServerLevel)level), (DifficultyInstance)level.getCurrentDifficultyAt(entityPosition), (MobSpawnType)MobSpawnType.EVENT, null);
            }
            if (e instanceof Sheep) {
                Sheep sheep = (Sheep)e;
                sheep.setColor(DyeColor.byId((int)level.random.nextInt(16)));
            }
            if (e instanceof AgeableMob) {
                mob = (AgeableMob)e;
                mob.setAge(-24000);
            }
            level.addFreshEntity(e);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, player.position());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult tryVeinMine(Player player, ItemStack stack, BlockPos pos, Direction sideHit) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        Level level = player.level();
        BlockState target = level.getBlockState(pos);
        if (target.getDestroySpeed((BlockGetter)level, pos) == -1.0f || !stack.isCorrectToolForDrops(target)) {
            return InteractionResult.FAIL;
        }
        AABB area = WorldHelper.getBroadDeepBox(pos, sideHit, ToolHelper.getCharge(stack));
        return ToolHelper.harvestVein(level, player, pos, stack, area, target.getBlock(), BlockBehaviour.BlockStateBase::is, (drops, lvl, p) -> {
            WorldHelper.createLootDrop((List<ItemStack>)drops, lvl, p);
            lvl.playSound(null, (double)p.getX(), (double)p.getY(), (double)p.getZ(), (SoundEvent)PESoundEvents.DESTRUCT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        });
    }

    public static InteractionResult mineOreVeinsInAOE(Player player, InteractionHand hand) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        Level level = player.level();
        ItemStack stack = player.getItemInHand(hand);
        BiPredicate<BlockState, ItemStack> stateChecker = (state, itemStack) -> state.is(Tags.Blocks.ORES) && itemStack.isCorrectToolForDrops(state);
        AABB area = player.getBoundingBox().inflate((double)(ToolHelper.getCharge(stack) + 3));
        return ToolHelper.harvestVein(level, player, player.blockPosition(), stack, area, stack, stateChecker, WorldHelper::createLootDrop);
    }

    public static <DATA> InteractionResult harvestVein(Level level, Player player, BlockPos dropPos, ItemStack stack, AABB area, DATA data, BiPredicate<BlockState, DATA> stateChecker, DropSpawner spawnDrops) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (WorldHelper.harvestVein(level, player, stack, area, drops, data, stateChecker) > 0) {
            if (!level.isClientSide) {
                spawnDrops.drop(drops, level, dropPos);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static float getDestroySpeed(float parentDestroySpeed, IMatterType matterType, int charge) {
        if (parentDestroySpeed == 1.0f) {
            return parentDestroySpeed;
        }
        return parentDestroySpeed + matterType.getChargeModifier() * (float)charge;
    }

    public static boolean canMatterMine(IMatterType matterType, Block block) {
        IMatterBlock matterBlock;
        return block instanceof IMatterBlock && (matterBlock = (IMatterBlock)block).getMatterType().getMatterTier() <= matterType.getMatterTier();
    }

    private static int getCharge(ItemStack stack) {
        IItemCharge charge = (IItemCharge)stack.getCapability(PECapabilities.CHARGE_ITEM_CAPABILITY);
        return charge == null ? 0 : charge.getCharge(stack);
    }

    public static void applyChargeAttributes(ItemAttributeModifierEvent event) {
        int charge = ToolHelper.getCharge(event.getItemStack());
        if (charge > 0) {
            event.addModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(CHARGE_MODIFIER_ID, (double)charge, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
    }

    private static class HoeToolAOEData
    extends FlatToolAOEData {
        private HoeToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos pos, BlockState state) {
            return true;
        }
    }

    private static interface IToolAOEData {
        public boolean isValid(Level var1, BlockPos var2, BlockState var3);

        default public void persistData(Level level, BlockPos pos, BlockState state, Direction side) {
        }

        public Iterable<BlockPos> getTargetPositions(BlockPos var1, Direction var2, int var3);
    }

    private static class ShovelToolAOEData
    extends FlatToolAOEData {
        private ShovelToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos pos, BlockState state) {
            BlockPos abovePos = pos.above();
            BlockState aboveState = level.getBlockState(abovePos);
            if (aboveState.isAir()) {
                return true;
            }
            if (aboveState.is(PETags.Blocks.FARMING_OVERRIDE) || aboveState.canBeReplaced() && aboveState.is(BlockTags.REPLACEABLE_BY_TREES)) {
                return aboveState.getFluidState().isEmpty() && !aboveState.isSolidRender((BlockGetter)level, abovePos);
            }
            return false;
        }
    }

    private static class AxeToolAOEData
    implements IToolAOEData {
        @Nullable
        private Direction.Axis axis;
        private boolean isSet;

        private AxeToolAOEData() {
        }

        @Override
        public boolean isValid(Level level, BlockPos blockPos, BlockState state) {
            return !this.isSet || this.axis == this.getAxis(state);
        }

        @Override
        public void persistData(Level level, BlockPos pos, BlockState state, Direction side) {
            this.axis = this.getAxis(state);
            this.isSet = true;
        }

        @Override
        public Iterable<BlockPos> getTargetPositions(BlockPos pos, Direction side, int radius) {
            return WorldHelper.getPositionsInBox(WorldHelper.getBroadBox(pos, side, radius));
        }

        @Nullable
        private Direction.Axis getAxis(BlockState state) {
            return state.hasProperty((Property)RotatedPillarBlock.AXIS) ? (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS) : null;
        }
    }

    @FunctionalInterface
    public static interface RayTracePointer {
        public BlockHitResult rayTrace(Level var1, Player var2, ClipContext.Fluid var3);
    }

    @FunctionalInterface
    public static interface DropSpawner {
        public void drop(List<ItemStack> var1, Level var2, BlockPos var3);
    }

    private static abstract class FlatToolAOEData
    implements IToolAOEData {
        private FlatToolAOEData() {
        }

        @Override
        public Iterable<BlockPos> getTargetPositions(BlockPos pos, Direction side, int radius) {
            return WorldHelper.horizontalPositionsAround(pos, radius);
        }
    }
}

