/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import moze_intel.projecte.gameObjs.block_entities.DMPedestalBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class PedestalRenderer
implements BlockEntityRenderer<DMPedestalBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public PedestalRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull DMPedestalBlockEntity pedestal, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight) {
        if (!pedestal.isRemoved() && pedestal.getLevel() != null) {
            ItemStack stack;
            if (this.context.getEntityRenderer().shouldRenderHitBoxes()) {
                matrix.pushPose();
                BlockPos pos = pedestal.getBlockPos();
                AABB aabb = pedestal.getEffectBounds().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
                VertexConsumer vertexBuilder = renderer.getBuffer(RenderType.lines());
                LevelRenderer.renderLineBox((PoseStack)matrix, (VertexConsumer)vertexBuilder, (double)aabb.minX, (double)aabb.minY, (double)aabb.minZ, (double)aabb.maxX, (double)aabb.maxY, (double)aabb.maxZ, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                matrix.popPose();
            }
            if (!(stack = pedestal.getInventory().getStackInSlot(0)).isEmpty()) {
                matrix.pushPose();
                matrix.translate(0.5, 0.7, 0.5);
                long gameTime = pedestal.getLevel().getGameTime();
                matrix.translate(0.0, (double)Mth.sin((float)(((float)gameTime + partialTick) / 10.0f)) * 0.1 + 0.1, 0.0);
                matrix.scale(0.75f, 0.75f, 0.75f);
                float angle = ((float)gameTime + partialTick) / 20.0f;
                matrix.mulPose(Axis.YP.rotation(angle));
                this.context.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlayLight, matrix, renderer, pedestal.getLevel(), (int)pedestal.getBlockPos().asLong());
                matrix.popPose();
            }
        }
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull DMPedestalBlockEntity pedestal) {
        if (this.context.getEntityRenderer().shouldRenderHitBoxes()) {
            return pedestal.getEffectBounds();
        }
        return super.getRenderBoundingBox((BlockEntity)pedestal);
    }
}

