/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.container.TransmutationContainer;
import moze_intel.projecte.gameObjs.items.rings.ArchangelSmite;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.network.packets.to_client.NovaExplosionSyncPKT;
import moze_intel.projecte.network.packets.to_client.SyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.SyncFuelMapperPKT;
import moze_intel.projecte.network.packets.to_client.SyncWorldTransmutations;
import moze_intel.projecte.network.packets.to_client.alch_bag.SyncAllBagDataPKT;
import moze_intel.projecte.network.packets.to_client.alch_bag.SyncBagsDataPKT;
import moze_intel.projecte.network.packets.to_client.container.SyncOffhandPkt;
import moze_intel.projecte.network.packets.to_client.container.UpdateCondenserLockPKT;
import moze_intel.projecte.network.packets.to_client.container.UpdateWindowLongPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncChangePKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncInputsAndLocksPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncPKT;
import moze_intel.projecte.network.packets.to_server.KeyPressPKT;
import moze_intel.projecte.network.packets.to_server.SearchUpdatePKT;
import moze_intel.projecte.network.packets.to_server.UpdateGemModePKT;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public final class PacketHandler {
    private SimplePacketPayLoad activateArchangel;
    private SimplePacketPayLoad clearKnowledge;
    private SimplePacketPayLoad updateTransmutationTargets;
    private SimplePacketPayLoad resetCooldown;

    public PacketHandler(IEventBus modEventBus, ArtifactVersion version) {
        modEventBus.addListener(RegisterPayloadHandlersEvent.class, event -> {
            PayloadRegistrar registrar = event.registrar(version.toString());
            this.registerClientToServer(new PacketRegistrar(registrar, true));
            this.registerServerToClient(new PacketRegistrar(registrar, false));
        });
    }

    private void registerClientToServer(PacketRegistrar registrar) {
        registrar.play(KeyPressPKT.TYPE, KeyPressPKT.STREAM_CODEC);
        this.activateArchangel = registrar.playInstanced(PECore.rl("activate_archangel"), (IPayloadHandler<CustomPacketPayload>)((IPayloadHandler)(ignored, context) -> {
            Player player = context.player();
            ItemStack main = player.getMainHandItem();
            if (!main.isEmpty() && main.is(PEItems.ARCHANGEL_SMITE)) {
                ArchangelSmite.fireVolley(main, player);
            }
        }));
        registrar.play(SearchUpdatePKT.TYPE, SearchUpdatePKT.STREAM_CODEC);
        registrar.play(UpdateGemModePKT.TYPE, UpdateGemModePKT.STREAM_CODEC);
    }

    private void registerServerToClient(PacketRegistrar registrar) {
        this.resetCooldown = registrar.playInstanced(PECore.rl("reset_cooldown"), (IPayloadHandler<CustomPacketPayload>)((IPayloadHandler)(ignored, context) -> context.player().resetAttackStrengthTicker()));
        this.clearKnowledge = registrar.playInstanced(PECore.rl("clear_knowledge"), (IPayloadHandler<CustomPacketPayload>)((IPayloadHandler)(ignored, context) -> {
            Player player = context.player();
            IKnowledgeProvider knowledge = (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
            if (knowledge != null) {
                knowledge.clearKnowledge();
                AbstractContainerMenu patt0$temp = player.containerMenu;
                if (patt0$temp instanceof TransmutationContainer) {
                    TransmutationContainer container = (TransmutationContainer)patt0$temp;
                    container.transmutationInventory.updateClientTargets(false);
                }
            }
        }));
        registrar.play(KnowledgeSyncPKT.TYPE, KnowledgeSyncPKT.STREAM_CODEC);
        registrar.play(KnowledgeSyncEmcPKT.TYPE, KnowledgeSyncEmcPKT.STREAM_CODEC);
        registrar.play(KnowledgeSyncInputsAndLocksPKT.TYPE, KnowledgeSyncInputsAndLocksPKT.STREAM_CODEC);
        registrar.play(KnowledgeSyncChangePKT.TYPE, KnowledgeSyncChangePKT.STREAM_CODEC);
        registrar.play(NovaExplosionSyncPKT.TYPE, NovaExplosionSyncPKT.STREAM_CODEC);
        registrar.play(SyncAllBagDataPKT.TYPE, SyncAllBagDataPKT.STREAM_CODEC);
        registrar.play(SyncBagsDataPKT.TYPE, SyncBagsDataPKT.STREAM_CODEC);
        registrar.play(SyncEmcPKT.TYPE, SyncEmcPKT.STREAM_CODEC);
        registrar.play(SyncOffhandPkt.TYPE, SyncOffhandPkt.STREAM_CODEC);
        registrar.play(SyncFuelMapperPKT.TYPE, SyncFuelMapperPKT.STREAM_CODEC);
        registrar.play(SyncWorldTransmutations.TYPE, SyncWorldTransmutations.STREAM_CODEC);
        registrar.play(UpdateCondenserLockPKT.TYPE, UpdateCondenserLockPKT.STREAM_CODEC);
        this.updateTransmutationTargets = registrar.playInstanced(PECore.rl("update_transmutation_targets"), (IPayloadHandler<CustomPacketPayload>)((IPayloadHandler)(ignored, context) -> {
            AbstractContainerMenu patt0$temp = context.player().containerMenu;
            if (patt0$temp instanceof TransmutationContainer) {
                TransmutationContainer container = (TransmutationContainer)patt0$temp;
                container.transmutationInventory.updateClientTargets(false);
            }
        }));
        registrar.play(UpdateWindowLongPKT.TYPE, UpdateWindowLongPKT.STREAM_CODEC);
    }

    public void clearKnowledge(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.clearKnowledge, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void updateTransmutationTargets(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.updateTransmutationTargets, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void resetCooldown(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.resetCooldown, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void activateArchangel() {
        PacketDistributor.sendToServer((CustomPacketPayload)this.activateArchangel, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected record PacketRegistrar(PayloadRegistrar registrar, boolean toServer) {
        public <MSG extends IPEPacket> void play(CustomPacketPayload.Type<MSG> type, StreamCodec<? super RegistryFriendlyByteBuf, MSG> reader) {
            if (this.toServer) {
                this.registrar.playToServer(type, reader, IPEPacket::handle);
            } else {
                this.registrar.playToClient(type, reader, IPEPacket::handle);
            }
        }

        public SimplePacketPayLoad playInstanced(ResourceLocation id, IPayloadHandler<CustomPacketPayload> handler) {
            SimplePacketPayLoad payload = new SimplePacketPayLoad(id);
            if (this.toServer) {
                this.registrar.playToServer(payload.type(), StreamCodec.unit((Object)payload), handler);
            } else {
                this.registrar.playToClient(payload.type(), StreamCodec.unit((Object)payload), handler);
            }
            return payload;
        }
    }

    protected record SimplePacketPayLoad(CustomPacketPayload.Type<CustomPacketPayload> type) implements CustomPacketPayload
    {
        private SimplePacketPayLoad(ResourceLocation id) {
            this((CustomPacketPayload.Type<CustomPacketPayload>)new CustomPacketPayload.Type(id));
        }
    }
}

