/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.Objects;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Range;

public class ItemPE
extends Item {
    public ItemPE(Item.Properties props) {
        super(props);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        IModeChanger modeChanger;
        if (oldStack.getItem() != newStack.getItem()) {
            return true;
        }
        if (oldStack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false) != newStack.getOrDefault(PEDataComponentTypes.ACTIVE, (Object)false)) {
            return true;
        }
        ItemPE itemPE = this;
        return itemPE instanceof IModeChanger && !ItemPE.modeMatches(modeChanger = (IModeChanger)((Object)itemPE), oldStack, newStack);
    }

    private static <MODE> boolean modeMatches(IModeChanger<MODE> modeChanger, ItemStack oldStack, ItemStack newStack) {
        return Objects.equals(modeChanger.getMode(oldStack), modeChanger.getMode(newStack));
    }

    private static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmc(ItemStack stack) {
        return (Long)stack.getOrDefault(PEDataComponentTypes.STORED_EMC, (Object)0L);
    }

    public static void removeEmc(ItemStack stack, float amount) {
        ItemPE.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, amount));
    }

    public static void removeEmc(ItemStack stack, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long amount) {
        if (amount > 0L) {
            stack.update(PEDataComponentTypes.STORED_EMC, (Object)0L, (Object)amount, (emc, change) -> Math.max(emc - change, 0L));
        }
    }

    public static boolean hasEmc(Player player, ItemStack stack, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long amount, boolean subUnitRemoval) {
        if (subUnitRemoval && ItemPE.getEmc(stack) > 0L) {
            return true;
        }
        return ItemPE.consumeFuel(player, stack, amount, false);
    }

    public static boolean consumeFuel(Player player, ItemStack stack, @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long amount, boolean shouldRemove) {
        if (amount <= 0L) {
            return true;
        }
        long current = ItemPE.getEmc(stack);
        boolean updateEmc = shouldRemove;
        if (current < amount) {
            long consume = EMCHelper.consumePlayerFuel(player, amount - current);
            if (consume == -1L) {
                return false;
            }
            long spaceFor = Long.MAX_VALUE - current;
            if (consume > spaceFor) {
                if (shouldRemove) {
                    shouldRemove = false;
                    current = (consume -= amount) > spaceFor ? Long.MAX_VALUE : (current += consume);
                } else {
                    current = Long.MAX_VALUE;
                }
            } else {
                current += consume;
            }
            updateEmc = true;
        }
        if (shouldRemove) {
            current -= amount;
        }
        if (updateEmc) {
            stack.set(PEDataComponentTypes.STORED_EMC, (Object)current);
        }
        return true;
    }

    public static boolean hotBarOrOffHand(int slot) {
        return slot < Inventory.getSelectionSize() || slot == 40;
    }
}

