/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.slots.transmutation;

import it.unimi.dsi.fastutil.ints.IntList;
import java.math.BigInteger;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.container.slots.InventoryContainerSlot;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class SlotLock
extends InventoryContainerSlot {
    private final TransmutationInventory inv;

    public SlotLock(TransmutationInventory inv, int index, int x, int y) {
        super((IItemHandler)inv, index, x, y);
        this.inv = inv;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return SlotPredicates.RELAY_INV.test(stack);
    }

    @NotNull
    public ItemStack remove(int amount) {
        ItemStack stack = super.remove(amount);
        if (!stack.isEmpty() && this.inv.isServer()) {
            this.inv.syncChangedSlots(IntList.of((int)this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.ALL);
        }
        return stack;
    }

    public void initialize(@NotNull ItemStack stack) {
        super.initialize(stack);
    }

    public void set(@NotNull ItemStack stack) {
        super.set(stack);
        if (this.inv.isServer()) {
            if (stack.isEmpty()) {
                this.inv.syncChangedSlots(IntList.of((int)this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.ALL);
            } else {
                IItemEmcHolder emcHolder;
                if (IEMCProxy.INSTANCE.hasValue(stack)) {
                    this.inv.handleKnowledge(stack);
                }
                if ((emcHolder = (IItemEmcHolder)stack.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY)) != null) {
                    long actualExtracted = emcHolder.extractEmc(stack, emcHolder.getStoredEmc(stack), IEmcStorage.EmcAction.EXECUTE);
                    if (actualExtracted > 0L) {
                        this.inv.syncChangedSlots(IntList.of((int)this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.NONE);
                        this.inv.addEmc(BigInteger.valueOf(actualExtracted));
                    } else {
                        this.inv.syncChangedSlots(IntList.of((int)this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.ALL);
                    }
                } else {
                    this.inv.syncChangedSlots(IntList.of((int)this.getSlotIndex()), IKnowledgeProvider.TargetUpdateType.ALL);
                }
            }
        }
    }

    public int getMaxStackSize() {
        return 1;
    }
}

