/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container.inventory;

import java.util.Set;
import moze_intel.projecte.components.GemData;
import moze_intel.projecte.gameObjs.registries.PEDataComponentTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class EternalDensityInventory
extends ItemStackHandler {
    private final ItemStack invItem;
    private final boolean remote;

    public EternalDensityInventory(ItemStack stack, boolean remote) {
        super(9);
        this.invItem = stack;
        this.remote = remote;
        int slot = 0;
        for (ItemStack whitelisted : ((GemData)this.invItem.getOrDefault(PEDataComponentTypes.GEM_DATA, (Object)GemData.EMPTY)).whitelist()) {
            if (whitelisted.isEmpty()) continue;
            this.stacks.set(slot++, (Object)whitelisted.copy());
            if (slot < this.getSlots()) continue;
            break;
        }
    }

    public int getSlots() {
        return 9;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        int slots = this.getSlots();
        for (int i = 0; i < slots; ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getStackInSlot(i))) continue;
            return i == slot;
        }
        return true;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (this.isItemValid(slot, stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    protected void onContentsChanged(int slot) {
        if (this.remote) {
            return;
        }
        Set targets = ItemStackLinkedSet.createTypeAndComponentsSet();
        int slots = this.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = this.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            targets.add(stackInSlot.copyWithCount(1));
        }
        this.invItem.update(PEDataComponentTypes.GEM_DATA, (Object)GemData.EMPTY, (Object)targets, GemData::withWhitelistSafe);
    }
}

