/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.container.DMFurnaceContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class DMFurnaceBlockEntity
extends EmcBlockEntity
implements MenuProvider,
RecipeCraftingHolder {
    public static final ICapabilityProvider<DMFurnaceBlockEntity, @Nullable Direction, IItemHandler> INVENTORY_PROVIDER = (furnace, side) -> {
        if (side == null) {
            return furnace.joined;
        }
        if (side == Direction.UP) {
            return furnace.automationInput;
        }
        if (side == Direction.DOWN) {
            return furnace.automationOutput;
        }
        return furnace.automationSides;
    };
    private static final long EMC_CONSUMPTION = 2L;
    private final EmcBlockEntity.CompactableStackHandler inputInventory = new EmcBlockEntity.CompactableStackHandler(this.getInvSize()){
        private ItemStack oldInput;
        {
            this.oldInput = ItemStack.EMPTY;
        }

        @Override
        protected void onLoad() {
            this.oldInput = this.getStackInSlot(0).copy();
        }

        @Override
        protected void onContentsChanged(int slot) {
            ItemStack input;
            super.onContentsChanged(slot);
            if (slot == 0 && !ItemStack.isSameItemSameComponents((ItemStack)this.oldInput, (ItemStack)(input = this.getStackInSlot(0)))) {
                RecipeResult recipeResult = DMFurnaceBlockEntity.this.getSmeltingRecipe(input);
                DMFurnaceBlockEntity.this.cookingTotalTime = DMFurnaceBlockEntity.this.getTotalCookTime(recipeResult);
                DMFurnaceBlockEntity.this.cookingProgress = 0;
                this.oldInput = input.copy();
            }
        }
    };
    private final EmcBlockEntity.CompactableStackHandler outputInventory = new EmcBlockEntity.CompactableStackHandler(this.getInvSize());
    private final EmcBlockEntity.StackHandler fuelInv = new EmcBlockEntity.StackHandler(1);
    private final IItemHandler joined;
    private final IItemHandlerModifiable automationInput;
    private final IItemHandlerModifiable automationOutput;
    private final IItemHandler automationSides;
    protected final int ticksBeforeSmelt;
    private final int efficiencyBonus;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<SingleRecipeInput, SmeltingRecipe> quickCheck;
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> pullTarget;
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> pushTarget;
    public int litTime;
    public int litDuration;
    public int cookingProgress;
    public int cookingTotalTime;

    public DMFurnaceBlockEntity(BlockPos pos, BlockState state) {
        this(PEBlockEntityTypes.DARK_MATTER_FURNACE, pos, state, 10, 3);
    }

    protected DMFurnaceBlockEntity(BlockEntityTypeRegistryObject<? extends DMFurnaceBlockEntity> type, BlockPos pos, BlockState state, int ticksBeforeSmelt, int efficiencyBonus) {
        super(type, pos, state, 64L);
        this.ticksBeforeSmelt = ticksBeforeSmelt;
        this.efficiencyBonus = efficiencyBonus;
        this.quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return DMFurnaceBlockEntity.this.hasSmeltingResult(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        this.automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.outputInventory, WrappedItemHandler.WriteMode.OUT);
        WrappedItemHandler automationFuel = new WrappedItemHandler(this, (IItemHandlerModifiable)this.fuelInv, WrappedItemHandler.WriteMode.IN){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SlotPredicates.FURNACE_FUEL.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }
        };
        this.automationSides = new CombinedInvWrapper(new IItemHandlerModifiable[]{automationFuel, this.automationOutput});
        this.joined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, automationFuel, this.automationOutput});
    }

    public void setLevel(@NotNull Level level) {
        super.setLevel(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.pullTarget = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.worldPosition.above(), (Object)Direction.DOWN);
            this.pushTarget = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.worldPosition.below(), (Object)Direction.UP);
        }
    }

    @Override
    protected boolean canProvideEmc() {
        return false;
    }

    @Override
    protected @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEmcInsertLimit() {
        return 2L;
    }

    protected int getInvSize() {
        return 9;
    }

    protected float getOreDoubleChance() {
        return 0.5f;
    }

    protected float getDoubleChance(ItemStack input) {
        if (input.is(Tags.Items.ORES)) {
            return this.getOreDoubleChance();
        }
        if (input.is(Tags.Items.RAW_MATERIALS)) {
            return this.getOreDoubleChance() * 2.0f / 3.0f;
        }
        return 0.0f;
    }

    public float getBurnProgress() {
        if (this.cookingTotalTime == 0) {
            return 0.0f;
        }
        int progress = this.isLit() && this.canSmelt(this.getSmeltingRecipe(this.getItemToSmelt())) ? this.cookingProgress + 1 : this.cookingProgress;
        return Mth.clamp((float)((float)progress / (float)this.cookingTotalTime), (float)0.0f, (float)1.0f);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInv, @NotNull Player playerIn) {
        return new DMFurnaceContainer(windowId, playerInv, this);
    }

    @NotNull
    public Component getDisplayName() {
        return PELang.GUI_DARK_MATTER_FURNACE.translate();
    }

    public IItemHandler getFuel() {
        return this.fuelInv;
    }

    private ItemStack getItemToSmelt() {
        return this.inputInventory.getStackInSlot(0);
    }

    private ItemStack getFuelItem() {
        return this.fuelInv.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInventory;
    }

    public IItemHandler getOutput() {
        return this.outputInventory;
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, DMFurnaceBlockEntity furnace) {
        IItemEmcHolder emcHolder;
        boolean wasBurning = furnace.isLit();
        int lastLitTime = furnace.litTime--;
        int lastCookingProgress = furnace.cookingProgress;
        if (furnace.isLit()) {
            // empty if block
        }
        furnace.inputInventory.compact();
        furnace.outputInventory.compact();
        furnace.pullFromInventories(level, pos);
        RecipeResult recipeResult = furnace.getSmeltingRecipe(level, furnace.getItemToSmelt());
        boolean canSmelt = furnace.canSmelt(recipeResult);
        ItemStack fuelItem = furnace.getFuelItem();
        if (canSmelt && (emcHolder = (IItemEmcHolder)fuelItem.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY)) != null) {
            long simulatedExtraction = emcHolder.extractEmc(fuelItem, 2L, IEmcStorage.EmcAction.SIMULATE);
            if (simulatedExtraction == 2L) {
                furnace.forceInsertEmc(emcHolder.extractEmc(fuelItem, simulatedExtraction, IEmcStorage.EmcAction.EXECUTE), IEmcStorage.EmcAction.EXECUTE);
            }
            furnace.markDirty(level, pos, false);
        }
        if (furnace.getStoredEmc() >= 2L) {
            furnace.litTime = 1;
            furnace.forceExtractEmc(2L, IEmcStorage.EmcAction.EXECUTE);
        }
        if (canSmelt) {
            if (furnace.litTime == 0) {
                furnace.litDuration = furnace.litTime = furnace.getItemBurnTime(fuelItem);
                if (furnace.isLit() && !fuelItem.isEmpty()) {
                    ItemStack copy = fuelItem.copy();
                    fuelItem.shrink(1);
                    furnace.fuelInv.onContentsChanged(0);
                    if (fuelItem.isEmpty()) {
                        furnace.fuelInv.setStackInSlot(0, copy.getItem().getCraftingRemainingItem(copy));
                    }
                    furnace.markDirty(level, pos, false);
                }
            }
            if (furnace.isLit() && ++furnace.cookingProgress == furnace.cookingTotalTime) {
                furnace.cookingProgress = 0;
                furnace.cookingTotalTime = furnace.getTotalCookTime(recipeResult);
                furnace.smeltItem(level, recipeResult);
            }
        } else {
            furnace.cookingProgress = 0;
        }
        if (wasBurning != furnace.isLit()) {
            if (state.getBlock() instanceof MatterFurnace) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MatterFurnace.LIT, (Comparable)Boolean.valueOf(furnace.isLit())));
            }
            furnace.markDirty(level, pos, true);
        }
        furnace.pushToInventories(level, pos);
        if (lastLitTime != furnace.litTime || lastCookingProgress != furnace.cookingProgress) {
            furnace.markDirty(level, pos, false);
        }
        furnace.updateComparators(level, pos);
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    private static boolean isHopper(@NotNull Level level, @NotNull BlockPos position) {
        return WorldHelper.getBlockEntity((BlockGetter)level, position) instanceof Hopper;
    }

    private void pullFromInventories(@NotNull Level level, @NotNull BlockPos pos) {
        if (this.pullTarget == null || DMFurnaceBlockEntity.isHopper(level, pos.above())) {
            return;
        }
        IItemHandler handler = (IItemHandler)this.pullTarget.getCapability();
        if (handler != null) {
            int slots = handler.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack extractTest = handler.extractItem(i, Integer.MAX_VALUE, true);
                if (extractTest.isEmpty()) continue;
                EmcBlockEntity.StackHandler targetInv = SlotPredicates.FURNACE_FUEL.test(extractTest) ? this.fuelInv : this.inputInventory;
                this.transferItem((IItemHandler)targetInv, i, extractTest, handler);
            }
        }
    }

    private void pushToInventories(@NotNull Level level, @NotNull BlockPos pos) {
        if (this.pushTarget == null || this.outputInventory.isEmpty() || DMFurnaceBlockEntity.isHopper(level, pos.below())) {
            return;
        }
        IItemHandler targetInv = (IItemHandler)this.pushTarget.getCapability();
        if (targetInv != null) {
            int slots = this.outputInventory.getSlots();
            for (int i = 0; i < slots; ++i) {
                ItemStack extractTest = this.outputInventory.extractItem(i, Integer.MAX_VALUE, true);
                if (extractTest.isEmpty()) continue;
                this.transferItem(targetInv, i, extractTest, (IItemHandler)this.outputInventory);
            }
        }
    }

    private void transferItem(IItemHandler targetInv, int i, ItemStack extractTest, IItemHandler outputInventory) {
        ItemStack remainderTest = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)extractTest, (boolean)true);
        int successfullyTransferred = extractTest.getCount() - remainderTest.getCount();
        if (successfullyTransferred > 0) {
            ItemStack toInsert = outputInventory.extractItem(i, successfullyTransferred, false);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)toInsert, (boolean)false);
            assert (result.isEmpty());
        }
    }

    private RecipeResult getSmeltingRecipe(ItemStack input) {
        return this.getSmeltingRecipe(this.level, input);
    }

    private RecipeResult getSmeltingRecipe(@Nullable Level level, ItemStack input) {
        if (level == null || input.isEmpty()) {
            return RecipeResult.EMPTY;
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput(input.copyWithCount(1));
        Optional optionalRecipe = this.quickCheck.getRecipeFor((RecipeInput)recipeInput, level);
        if (optionalRecipe.isPresent()) {
            RecipeHolder recipeHolder = (RecipeHolder)optionalRecipe.get();
            return new RecipeResult((RecipeHolder<SmeltingRecipe>)recipeHolder, ((SmeltingRecipe)recipeHolder.value()).assemble(recipeInput, (HolderLookup.Provider)level.registryAccess()));
        }
        return RecipeResult.EMPTY;
    }

    public boolean hasSmeltingResult(ItemStack input) {
        return this.getSmeltingRecipe(input).hasResult();
    }

    private void smeltItem(@NotNull Level level, @NotNull RecipeResult recipeResult) {
        ItemStack toSmelt = this.getItemToSmelt();
        ItemStack smeltResult = recipeResult.scaledResult(level.random, this.getDoubleChance(toSmelt));
        if (!smeltResult.isEmpty()) {
            ItemStack fuelItem;
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)smeltResult, (boolean)false);
            if (toSmelt.is(Items.WET_SPONGE) && !(fuelItem = this.getFuelItem()).isEmpty() && fuelItem.is(Items.BUCKET)) {
                this.fuelInv.setStackInSlot(0, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            toSmelt.shrink(1);
            this.inputInventory.onContentsChanged(0);
            this.setRecipeUsed(recipeResult.recipeHolder());
        }
    }

    private boolean canSmelt(RecipeResult recipeResult) {
        ItemStack smeltResult = recipeResult.result();
        if (smeltResult.isEmpty()) {
            return false;
        }
        ItemStack currentSmelted = this.outputInventory.getStackInSlot(this.outputInventory.getSlots() - 1);
        if (currentSmelted.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)smeltResult, (ItemStack)currentSmelted)) {
            return false;
        }
        int result = currentSmelted.getCount() + smeltResult.getCount();
        return result <= currentSmelted.getMaxStackSize();
    }

    private int getItemBurnTime(ItemStack stack) {
        return stack.getBurnTime(RecipeType.SMELTING) * this.ticksBeforeSmelt / 200 * this.efficiencyBonus;
    }

    private int getTotalCookTime(RecipeResult recipeResult) {
        if (recipeResult.recipeHolder() == null) {
            return this.ticksBeforeSmelt;
        }
        int cookingTime = ((SmeltingRecipe)recipeResult.recipeHolder().value()).getCookingTime();
        return Mth.ceil((float)((float)(this.ticksBeforeSmelt * cookingTime) / 200.0f));
    }

    public float getLitProgress() {
        int litDuration = this.litDuration;
        if (litDuration == 0) {
            litDuration = this.ticksBeforeSmelt;
        }
        return Mth.clamp((float)((float)this.litTime / (float)litDuration), (float)0.0f, (float)1.0f);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.litTime = tag.getInt("burn_time");
        this.cookingProgress = tag.getInt("cook_time");
        this.cookingTotalTime = tag.getInt("cook_time_total");
        this.fuelInv.deserializeNBT(registries, tag.getCompound("fuel"));
        this.inputInventory.deserializeNBT(registries, tag.getCompound("input"));
        this.outputInventory.deserializeNBT(registries, tag.getCompound("output"));
        this.litDuration = this.getItemBurnTime(this.getFuelItem());
        CompoundTag usedRecipes = tag.getCompound("recipes_used");
        for (String recipeId : usedRecipes.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)recipeId), usedRecipes.getInt(recipeId));
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("burn_time", this.litTime);
        tag.putInt("cook_time", this.cookingProgress);
        tag.putInt("cook_time_total", this.cookingTotalTime);
        tag.put("input", (Tag)this.inputInventory.serializeNBT(registries));
        tag.put("output", (Tag)this.outputInventory.serializeNBT(registries));
        tag.put("fuel", (Tag)this.fuelInv.serializeNBT(registries));
        CompoundTag usedRecipes = new CompoundTag();
        ObjectIterator iterator = Object2IntMaps.fastIterator(this.recipesUsed);
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            usedRecipes.putInt(((ResourceLocation)entry.getKey()).toString(), entry.getIntValue());
        }
        tag.put("recipes_used", (Tag)usedRecipes);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipeHolder) {
        if (recipeHolder != null) {
            this.recipesUsed.addTo((Object)recipeHolder.id(), 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(@NotNull Player player, @NotNull List<ItemStack> items) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> recipes = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(recipes);
        for (RecipeHolder<?> recipeholder : recipes) {
            player.triggerRecipeCrafted(recipeholder, Collections.emptyList());
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        RecipeManager recipeManager = level.getRecipeManager();
        ArrayList list = new ArrayList();
        ObjectIterator iterator = Object2IntMaps.fastIterator(this.recipesUsed);
        while (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            Optional optionalRecipe = recipeManager.byKey((ResourceLocation)entry.getKey());
            if (!optionalRecipe.isPresent()) continue;
            RecipeHolder recipeHolder = (RecipeHolder)optionalRecipe.get();
            list.add(recipeHolder);
            Recipe recipe = recipeHolder.value();
            if (!(recipe instanceof SmeltingRecipe)) continue;
            SmeltingRecipe recipe2 = (SmeltingRecipe)recipe;
            DMFurnaceBlockEntity.createExperience(level, popVec, entry.getIntValue(), recipe2.getExperience());
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
        float indexBasedExperience = (float)recipeIndex * experience;
        int amount = Mth.floor((float)indexBasedExperience);
        float partial = indexBasedExperience - (float)amount;
        if (partial != 0.0f && Math.random() < (double)partial) {
            ++amount;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)popVec, (int)amount);
    }

    private record RecipeResult(@Nullable RecipeHolder<SmeltingRecipe> recipeHolder, ItemStack result) {
        private static final RecipeResult EMPTY = new RecipeResult(null, ItemStack.EMPTY);

        public ItemStack scaledResult(RandomSource random, float doubleChance) {
            if (random.nextFloat() < doubleChance) {
                return this.result.copyWithCount(2 * this.result.getCount());
            }
            return this.result.copy();
        }

        public boolean hasResult() {
            return !this.result.isEmpty();
        }
    }
}

