/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.utils.Constants;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRecipeTypeMapper
implements IRecipeTypeMapper {
    @Override
    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, RecipeHolder<?> recipeHolder, RegistryAccess registryAccess, INSSFakeGroupManager fakeGroupManager) {
        Recipe recipe = recipeHolder.value();
        if (recipe.isSpecial()) {
            return false;
        }
        ItemStack recipeOutput = recipe.getResultItem((HolderLookup.Provider)registryAccess);
        if (recipeOutput.isEmpty()) {
            return false;
        }
        Collection<Ingredient> ingredientsChecked = this.getIngredientsChecked(recipeHolder);
        if (ingredientsChecked == null) {
            return true;
        }
        ResourceLocation recipeID = recipeHolder.id();
        Object2IntOpenHashMap ingredientMap = new Object2IntOpenHashMap();
        for (Ingredient recipeItem : ingredientsChecked) {
            if (recipeItem.isEmpty()) continue;
            ItemStack[] matches = this.getMatchingStacks(recipeItem, recipeID);
            if (matches.length == 0) {
                return true;
            }
            if (matches.length == 1) {
                ItemStack match = matches[0];
                if (match.isEmpty()) {
                    return false;
                }
                if (BaseRecipeTypeMapper.representsEmptyTag(match)) {
                    return true;
                }
                if (!this.addIngredient((Object2IntMap<NormalizedSimpleStack>)ingredientMap, match, recipeID)) continue;
                return true;
            }
            Object2IntOpenHashMap rawNSSMatches = new Object2IntOpenHashMap(matches.length);
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(matches.length);
            for (ItemStack match : matches) {
                if (match.isEmpty() || BaseRecipeTypeMapper.representsEmptyTag(match)) continue;
                rawNSSMatches.put((Object)NSSItem.createItem(match), 1);
                stacks.add(match);
            }
            int count = stacks.size();
            if (count == 0) {
                return true;
            }
            if (count > 1) {
                INSSFakeGroupManager.FakeGroupData group = fakeGroupManager.getOrCreateFakeGroupDirect((Object2IntMap<NormalizedSimpleStack>)rawNSSMatches, true, true);
                NormalizedSimpleStack dummy = group.dummy();
                ingredientMap.mergeInt((Object)dummy, 1, Constants.INT_SUM);
                if (!group.created()) continue;
                boolean success = false;
                Iterator iterator = stacks.iterator();
                while (iterator.hasNext()) {
                    Object2IntArrayMap groupIngredientMap = new Object2IntArrayMap(2);
                    ItemStack stack = (ItemStack)iterator.next();
                    if (this.addIngredient((Object2IntMap<NormalizedSimpleStack>)groupIngredientMap, stack, recipeID)) continue;
                    mapper.addConversion(1, dummy, (Object2IntMap<NormalizedSimpleStack>)groupIngredientMap);
                    success = true;
                }
                if (success) continue;
                return true;
            }
            if (!this.addIngredient((Object2IntMap<NormalizedSimpleStack>)ingredientMap, (ItemStack)stacks.getFirst(), recipeID)) continue;
            return true;
        }
        mapper.addConversion(recipeOutput.getCount(), (NormalizedSimpleStack)NSSItem.createItem(recipeOutput), (Object2IntMap<NormalizedSimpleStack>)ingredientMap);
        return true;
    }

    private static boolean representsEmptyTag(ItemStack stack) {
        MutableComponent hoverName;
        Component component;
        return stack.getItem() == Items.BARRIER && (component = stack.getHoverName()) instanceof MutableComponent && (hoverName = (MutableComponent)component).getString().startsWith("Empty Tag: ");
    }

    private ItemStack[] getMatchingStacks(Ingredient ingredient, ResourceLocation recipeID) {
        try {
            return ingredient.getItems();
        }
        catch (Exception e) {
            ICustomIngredient customIngredient = ingredient.getCustomIngredient();
            if (customIngredient != null) {
                ResourceLocation name = NeoForgeRegistries.INGREDIENT_TYPES.getKey((Object)customIngredient.getType());
                if (name == null) {
                    PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Error mapping recipe {}. Ingredient of type: {} crashed when getting the matching stacks. Please report this to the ingredient's creator.", new Object[]{recipeID, customIngredient.getClass(), e});
                } else {
                    PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Error mapping recipe {}. Ingredient of type: {} crashed when getting the matching stacks. Please report this to the ingredient's creator ({}).", new Object[]{recipeID, name, name.getNamespace(), e});
                }
            } else {
                PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Error mapping recipe {}. Crashed when getting the matching stacks.", (Object)recipeID, (Object)e);
            }
            return new ItemStack[0];
        }
    }

    private boolean addIngredient(Object2IntMap<NormalizedSimpleStack> ingredientMap, ItemStack stack, ResourceLocation recipeID) {
        stack = stack.copy();
        Item item = stack.getItem();
        boolean hasContainerItem = false;
        try {
            hasContainerItem = item.hasCraftingRemainingItem(stack);
            if (hasContainerItem) {
                ingredientMap.mergeInt((Object)NSSItem.createItem(item.getCraftingRemainingItem(stack)), -1, Constants.INT_SUM);
            }
        }
        catch (Exception e) {
            ResourceLocation itemName = BuiltInRegistries.ITEM.getKey((Object)item);
            if (hasContainerItem) {
                PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Error mapping recipe {}. Item: {} reported that it has a container item, but errors when trying to get the container item based on the stack in the recipe. Please report this to {}.", new Object[]{recipeID, itemName, itemName.getNamespace(), e});
            } else {
                PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Error mapping recipe {}. Item: {} crashed when checking if the stack in the recipe has a container item. Please report this to {}.", new Object[]{recipeID, itemName, itemName.getNamespace(), e});
            }
            return true;
        }
        ingredientMap.mergeInt((Object)NSSItem.createItem(stack), 1, Constants.INT_SUM);
        return false;
    }

    @Nullable
    private Collection<Ingredient> getIngredientsChecked(RecipeHolder<?> recipeHolder) {
        try {
            return this.getIngredients(recipeHolder.value());
        }
        catch (Exception e) {
            ResourceLocation recipeID = recipeHolder.id();
            PECore.LOGGER.error(LogUtils.FATAL_MARKER, "Error mapping recipe {}. Failed to get ingredients. Please report this to {}.", new Object[]{recipeID, recipeID.getNamespace(), e});
            return null;
        }
    }

    protected Collection<Ingredient> getIngredients(Recipe<?> recipe) {
        return recipe.getIngredients();
    }
}

