/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.config.value;

import java.util.function.IntSupplier;
import moze_intel.projecte.config.IPEConfig;
import moze_intel.projecte.config.value.CachedValue;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CachedIntValue
extends CachedValue<Integer>
implements IntSupplier {
    private boolean resolved;
    private int cachedValue;

    private CachedIntValue(IPEConfig config, ModConfigSpec.ConfigValue<Integer> internal) {
        super(config, internal);
    }

    public static CachedIntValue wrap(IPEConfig config, ModConfigSpec.ConfigValue<Integer> internal) {
        return new CachedIntValue(config, internal);
    }

    public int getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Integer)this.internal.getDefault();
    }

    public int get() {
        if (!this.resolved) {
            this.cachedValue = (Integer)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public int getAsInt() {
        return this.get();
    }

    public void set(int value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        int oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

