/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.world_transmutation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutation;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SimpleWorldTransmutation(@NotNull Holder<Block> origin, @NotNull Holder<Block> result, @NotNull Holder<Block> altResult) implements IWorldTransmutation
{
    private static final Codec<Holder<Block>> BLOCK_CODEC = BuiltInRegistries.BLOCK.holderByNameCodec();
    private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Block>> BLOCK_STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.BLOCK);
    public static final Codec<SimpleWorldTransmutation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BLOCK_CODEC.fieldOf("origin").forGetter(SimpleWorldTransmutation::origin), (App)BLOCK_CODEC.fieldOf("result").forGetter(SimpleWorldTransmutation::result), (App)BLOCK_CODEC.optionalFieldOf("alt_result").forGetter(entry -> entry.hasAlternate() ? Optional.of(entry.altResult()) : Optional.empty())).apply((Applicative)instance, (origin, result, altResult) -> new SimpleWorldTransmutation((Holder<Block>)origin, (Holder<Block>)result, (Holder<Block>)altResult.orElse(result))));
    public static final StreamCodec<RegistryFriendlyByteBuf, SimpleWorldTransmutation> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SimpleWorldTransmutation>(){

        @NotNull
        public SimpleWorldTransmutation decode(@NotNull RegistryFriendlyByteBuf buffer) {
            Holder origin = (Holder)BLOCK_STREAM_CODEC.decode((Object)buffer);
            Holder result = (Holder)BLOCK_STREAM_CODEC.decode((Object)buffer);
            if (buffer.readBoolean()) {
                return new SimpleWorldTransmutation((Holder<Block>)origin, (Holder<Block>)result, (Holder<Block>)((Holder)BLOCK_STREAM_CODEC.decode((Object)buffer)));
            }
            return new SimpleWorldTransmutation((Holder<Block>)origin, (Holder<Block>)result);
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buffer, @NotNull SimpleWorldTransmutation transmutation) {
            BLOCK_STREAM_CODEC.encode((Object)buffer, transmutation.origin());
            BLOCK_STREAM_CODEC.encode((Object)buffer, transmutation.result());
            boolean hasAlternate = transmutation.hasAlternate();
            buffer.writeBoolean(hasAlternate);
            if (hasAlternate) {
                BLOCK_STREAM_CODEC.encode((Object)buffer, transmutation.altResult());
            }
        }
    };

    public SimpleWorldTransmutation(@NotNull Holder<Block> origin, @NotNull Holder<Block> result, @NotNull Holder<Block> altResult) {
        Objects.requireNonNull(origin, "Origin state cannot be null");
        Objects.requireNonNull(result, "Result state cannot be null");
        Objects.requireNonNull(altResult, "Alternate result state cannot be null");
    }

    public SimpleWorldTransmutation(@NotNull Holder<Block> origin, @NotNull Holder<Block> result) {
        this(origin, result, result);
    }

    @Override
    public boolean hasAlternate() {
        return this.result != this.altResult && !this.result.is(this.altResult);
    }

    @Override
    @Nullable
    public BlockState result(@NotNull BlockState state, boolean isSneaking) {
        if (this.canTransmute(state)) {
            Holder<Block> resultBlock = isSneaking ? this.altResult : this.result;
            return ((Block)resultBlock.value()).withPropertiesOf(state);
        }
        return null;
    }

    @Override
    public boolean canTransmute(@NotNull BlockState state) {
        return state.is(this.origin);
    }

    @Override
    public String toString() {
        String representation = "Simple World Transmutation from: " + this.origin.getRegisteredName() + " to: " + this.result.getRegisteredName();
        if (this.hasAlternate()) {
            representation = representation + ", with secondary output of: " + this.altResult.getRegisteredName();
        }
        return representation;
    }
}

