/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import javax.annotation.ParametersAreNonnullByDefault;
import moze_intel.projecte.api.data.ConversionBuilder;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
interface ConversionBuilderNSSHelper<PARENT> {
    public ConversionBuilder<PARENT> ingredient(NormalizedSimpleStack var1, int var2);

    default public ConversionBuilder<PARENT> ingredient(NormalizedSimpleStack input) {
        return this.ingredient(input, 1);
    }

    default public ConversionBuilder<PARENT> ingredient(ItemStack input) {
        return this.ingredient(NSSItem.createItem(input), input.getCount());
    }

    default public ConversionBuilder<PARENT> ingredient(ItemLike input) {
        return this.ingredient(input, 1);
    }

    default public ConversionBuilder<PARENT> ingredient(ItemLike input, int amount) {
        return this.ingredient(NSSItem.createItem(input), amount);
    }

    default public ConversionBuilder<PARENT> ingredient(TagKey<Item> input) {
        return this.ingredient(input, 1);
    }

    default public ConversionBuilder<PARENT> ingredient(TagKey<Item> input, int amount) {
        return this.ingredient(NSSItem.createTag(input), amount);
    }

    default public ConversionBuilder<PARENT> ingredient(FluidStack input) {
        return this.ingredient(NSSFluid.createFluid(input), input.getAmount());
    }

    default public ConversionBuilder<PARENT> ingredient(Fluid input) {
        return this.ingredient(input, 1);
    }

    default public ConversionBuilder<PARENT> ingredient(Fluid input, int amount) {
        return this.ingredient(NSSFluid.createFluid(input), amount);
    }

    default public ConversionBuilder<PARENT> ingredientFluid(TagKey<Fluid> input) {
        return this.ingredientFluid(input, 1);
    }

    default public ConversionBuilder<PARENT> ingredientFluid(TagKey<Fluid> input, int amount) {
        return this.ingredient(NSSFluid.createTag(input), amount);
    }

    default public ConversionBuilder<PARENT> ingredient(String fake) {
        return this.ingredient(fake, 1);
    }

    default public ConversionBuilder<PARENT> ingredient(String fake, int amount) {
        return this.ingredient(NSSFake.create(fake), amount);
    }
}

