/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.util;

import cofh.thermalfoundation.util.LexiconManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerLexicon {
    public static EventHandlerLexicon INSTANCE = new EventHandlerLexicon();

    public static void initialize() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleEntityItemPickupEvent(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d();
        if (stack.func_190926_b() || !LexiconManager.validOre(stack)) {
            return;
        }
        NBTTagCompound tag = event.getEntityPlayer().getEntityData();
        if (event.getEntityPlayer().field_70170_p.func_82737_E() - tag.func_74763_f("thermalfoundation.lexicon_timer") > 20L) {
            return;
        }
        event.setResult(Event.Result.DENY);
        ItemStack lexiconStack = LexiconManager.getPreferredStack(event.getEntityPlayer(), stack);
        if (!event.getEntityPlayer().field_71071_by.func_70441_a(lexiconStack)) {
            stack.func_190920_e(lexiconStack.func_190916_E());
            event.getItem().func_92058_a(stack);
            return;
        }
        stack.func_190920_e(0);
        FMLCommonHandler.instance().firePlayerItemPickupEvent(event.getEntityPlayer(), event.getItem());
        if (stack.func_190916_E() <= 0) {
            event.getItem().func_70106_y();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handlePlayerCloneEvent(PlayerEvent.Clone event) {
        NBTTagCompound newTag = event.getEntityPlayer().getEntityData();
        NBTTagCompound oldTag = event.getOriginal().getEntityData();
        if (oldTag.func_74764_b("thermalfoundation.lexicon_data")) {
            newTag.func_74782_a("thermalfoundation.lexicon_data", (NBTBase)oldTag.func_74775_l("thermalfoundation.lexicon_data"));
        }
    }
}

