/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.api.core.IPortableData;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.util.helpers.RedprintHelper;
import cofh.thermalfoundation.util.helpers.SchematicHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDiagram
extends ItemMulti
implements IInitializer {
    public static ItemStack schematic;
    public static ItemStack formula;
    public static ItemStack scroll;
    public static ItemStack redprint;
    public static ItemStack enderprint;

    public ItemDiagram() {
        super("thermalfoundation");
        this.func_77655_b("diagram");
        this.func_77637_a(ThermalFoundation.tabCommon);
        this.func_77627_a(true);
    }

    private void doRedprintUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IPortableData) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
                ((IPortableData)tile).writePortableData(player, stack.func_77978_p());
                if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
                    stack.func_77982_d(null);
                } else {
                    stack.func_77978_p().func_74778_a("Type", ((IPortableData)tile).getDataType());
                    player.func_184185_a(SoundEvents.field_187604_bf, 0.6f, 0.7f);
                }
            } else if (stack.func_77978_p().func_74779_i("Type").equals(((IPortableData)tile).getDataType())) {
                ((IPortableData)tile).readPortableData(player, stack.func_77978_p());
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case SCHEMATIC: {
                SchematicHelper.addInformation(stack, tooltip);
                break;
            }
            case FORMULA: {
                break;
            }
            case SCROLL: {
                break;
            }
            case REDPRINT: {
                RedprintHelper.addInformation(stack, tooltip);
                break;
            }
            case ENDERPRINT: {
                break;
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        String baseName = StringHelper.localize((String)(this.func_77667_c(stack) + ".name"));
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case SCHEMATIC: {
                baseName = baseName + SchematicHelper.getDisplayName(stack);
                break;
            }
            case FORMULA: {
                break;
            }
            case SCROLL: {
                break;
            }
            case REDPRINT: {
                baseName = baseName + RedprintHelper.getDisplayName(stack);
                break;
            }
            case ENDERPRINT: {
                break;
            }
        }
        return baseName;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return RedprintHelper.getDisplayName(stack).isEmpty() ? EnumRarity.COMMON : EnumRarity.UNCOMMON;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (stack.func_77978_p() != null) {
                player.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.3f);
            }
            stack.func_77982_d(null);
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return player.func_175151_a(pos.func_177972_a(facing), facing, player.func_184586_b(hand)) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (stack.func_77978_p() != null) {
                player.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.3f);
            }
            stack.func_77982_d(null);
        }
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case REDPRINT: {
                this.doRedprintUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
                break;
            }
            default: {
                return EnumActionResult.PASS;
            }
        }
        ServerHelper.sendItemUsePacket((World)world, (BlockPos)pos, (EnumFacing)side, (EnumHand)hand, (float)hitX, (float)hitY, (float)hitZ);
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper(this.modName, "util", this.name);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)mapper);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + "util", "type=" + ((ItemMulti.ItemEntry)entry.getValue()).name));
        }
    }

    public boolean initialize() {
        schematic = this.addItem(Type.SCHEMATIC.ordinal(), "schematic");
        redprint = this.addItem(Type.REDPRINT.ordinal(), "redprint");
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addShapelessRecipe((ItemStack)redprint, (Object[])new Object[]{Items.field_151121_aF, Items.field_151121_aF, "dustRedstone"});
        return true;
    }

    public static enum Type {
        SCHEMATIC,
        FORMULA,
        SCROLL,
        REDPRINT,
        ENDERPRINT;

    }
}

