/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.gui.client;

import cofh.core.gui.GuiColor;
import cofh.core.gui.GuiCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementListBox;
import cofh.core.gui.element.ElementTextField;
import cofh.core.gui.element.listbox.IListBoxElement;
import cofh.core.gui.element.listbox.ListBoxElementText;
import cofh.core.gui.element.listbox.SliderVertical;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.gui.container.ContainerLexiconStudy;
import cofh.thermalfoundation.network.PacketTFBase;
import cofh.thermalfoundation.util.LexiconManager;
import java.util.Locale;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiLexiconStudy
extends GuiCore {
    private static final String TEX_PATH = "thermalfoundation:textures/gui/lexicon_study.png";
    private static final ResourceLocation TEXTURE = new ResourceLocation("thermalfoundation:textures/gui/lexicon_study.png");
    private String searchLocal = "<" + StringHelper.localize((String)"gui.thermalfoundation.lexicon.search") + ">";
    private ElementTextField searchBox = new ElementTextField(this, 42, 87, 124, 10){
        public boolean searchUp;
        boolean rightClick;
        {
            this.searchUp = true;
            this.rightClick = false;
        }

        public ElementTextField setFocused(boolean focused) {
            if (focused && this.searchUp) {
                this.setText("");
                this.searchUp = false;
            }
            return super.setFocused(focused);
        }

        public boolean onKeyTyped(char charTyped, int keyTyped) {
            if (!super.onKeyTyped(charTyped, keyTyped)) {
                return false;
            }
            if (this.textLength <= 0) {
                GuiLexiconStudy.this.buildFullOreList();
            } else {
                GuiLexiconStudy.this.buildOreList(this.getText());
            }
            if (GuiLexiconStudy.this.oreList.getElementCount() <= 0) {
                GuiLexiconStudy.this.oreList.setSelectedIndex(-1);
            } else {
                GuiLexiconStudy.this.oreList.setSelectedIndex(0);
            }
            if (GuiLexiconStudy.this.oreList.getSelectedElement() != null) {
                GuiLexiconStudy.this.lexicon.onSelectionChanged((String)GuiLexiconStudy.this.oreList.getSelectedElement().getValue());
            }
            GuiLexiconStudy.this.oreSlider.setLimits(0, GuiLexiconStudy.this.oreList.getElementCount() - 8);
            return true;
        }

        protected void onFocusLost() {
            if (this.textLength <= 0) {
                GuiLexiconStudy.this.buildFullOreList();
                GuiLexiconStudy.this.oreSlider.setLimits(0, GuiLexiconStudy.this.oreList.getElementCount() - 8);
                this.setText("");
                this.searchUp = true;
            }
        }

        public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
            if (mouseButton == 1) {
                this.rightClick = true;
                GuiLexiconStudy.this.buildFullOreList();
                GuiLexiconStudy.this.oreList.setSelectedIndex(0);
                GuiLexiconStudy.this.oreSlider.setLimits(0, GuiLexiconStudy.this.oreList.getElementCount() - 8);
                this.setText("");
                this.setFocused(true);
            }
            return super.onMousePressed(mouseX, mouseY, mouseButton);
        }

        public void onMouseReleased(int mouseX, int mouseY) {
            if (this.rightClick) {
                this.rightClick = false;
            } else {
                super.onMouseReleased(mouseX, mouseY);
            }
        }

        public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        }
    };
    ElementListBox oreList = new ElementListBox(this, 22, 104, 162, 82){

        protected void onSelectionChanged(int newIndex, IListBoxElement newElement) {
            if (newIndex > -1) {
                GuiLexiconStudy.this.lexicon.onSelectionChanged((String)newElement.getValue());
            }
        }

        protected void onScrollV(int newStartIndex) {
            GuiLexiconStudy.this.oreSlider.setValue(newStartIndex);
        }

        protected void onScrollH(int newStartIndex) {
        }
    };
    SliderVertical oreSlider;
    ElementButton prevOre;
    ElementButton nextOre;
    ElementButton setPreferredOre;
    ElementButton clearPreferredOre;
    ContainerLexiconStudy lexicon;

    public GuiLexiconStudy(InventoryPlayer inventory, ContainerLexiconStudy container) {
        super((Container)container);
        this.lexicon = container;
        this.texture = TEXTURE;
        this.name = "gui.thermalfoundation.lexicon.study";
        this.field_146291_p = false;
        this.drawTitle = false;
        this.drawInventory = false;
        this.field_146999_f = 206;
        this.field_147000_g = 204;
        this.myInfo = StringHelper.localize((String)"tab.thermalfoundation.lexicon.study.0") + "\n\n" + StringHelper.localize((String)"tab.thermalfoundation.lexicon.study.1");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab(new TabInfo((GuiCore)this, this.myInfo).setOffsets(12, 10));
        this.prevOre = new ElementButton((GuiCore)this, 57, 31, "PrevOre", 206, 0, 206, 20, 206, 40, 20, 20, TEX_PATH);
        this.nextOre = new ElementButton((GuiCore)this, 129, 31, "NextOre", 226, 0, 226, 20, 226, 40, 20, 20, TEX_PATH);
        this.setPreferredOre = new ElementButton((GuiCore)this, 78, 59, "SetPreferred", 206, 60, 206, 80, 206, 100, 20, 20, TEX_PATH);
        this.clearPreferredOre = new ElementButton((GuiCore)this, 108, 59, "ClearPreferred", 226, 60, 226, 80, 226, 100, 20, 20, TEX_PATH);
        this.oreList.borderColor = new GuiColor(120, 120, 120, 0).getColor();
        this.oreList.backgroundColor = new GuiColor(0, 0, 0, 48).getColor();
        this.addElement((ElementBase)this.prevOre);
        this.addElement((ElementBase)this.nextOre);
        this.addElement((ElementBase)this.setPreferredOre);
        this.addElement((ElementBase)this.clearPreferredOre);
        this.addElement((ElementBase)this.searchBox);
        this.addElement((ElementBase)this.oreList);
        this.buildFullOreList();
        this.lexicon.onSelectionChanged((String)this.oreList.getSelectedElement().getValue());
        this.oreSlider = new SliderVertical(this, 184, 105, 8, 80, this.oreList.getElementCount() - 8){

            public void onValueChanged(int value) {
                GuiLexiconStudy.this.oreList.scrollToV(value);
            }
        };
        this.addElement((ElementBase)this.oreSlider);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    protected void updateElementInformation() {
        if (this.lexicon.hasMultipleOres()) {
            this.prevOre.setActive();
            this.nextOre.setActive();
            this.prevOre.setToolTip("gui.thermalfoundation.lexicon.prevEntry");
            this.nextOre.setToolTip("gui.thermalfoundation.lexicon.nextEntry");
        } else {
            this.prevOre.setDisabled();
            this.nextOre.setDisabled();
            this.prevOre.setToolTip("gui.thermalfoundation.lexicon.singleEntry");
            this.nextOre.setToolTip("gui.thermalfoundation.lexicon.singleEntry");
        }
        if (this.lexicon.canSetPreferred()) {
            this.setPreferredOre.setActive();
            this.setPreferredOre.setToolTip("gui.thermalfoundation.lexicon.setPreference");
        } else {
            this.setPreferredOre.setDisabled();
            this.setPreferredOre.clearToolTip();
        }
        if (this.lexicon.hasPreferredOre()) {
            this.clearPreferredOre.setActive();
            this.clearPreferredOre.setToolTip("gui.thermalfoundation.lexicon.clearPreference");
        } else {
            this.clearPreferredOre.setDisabled();
            this.clearPreferredOre.clearToolTip();
        }
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (buttonName.equalsIgnoreCase("PrevOre")) {
            PacketTFBase.sendLexiconStudyPacketToServer(0);
        } else if (buttonName.equalsIgnoreCase("NextOre")) {
            PacketTFBase.sendLexiconStudyPacketToServer(1);
        } else if (buttonName.equalsIgnoreCase("SetPreferred")) {
            PacketTFBase.sendLexiconStudyPacketToServer(2);
        } else if (buttonName.equalsIgnoreCase("ClearPreferred")) {
            PacketTFBase.sendLexiconStudyPacketToServer(3);
        }
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b(StringHelper.localize((String)this.name), this.getCenteredOffset(StringHelper.localize((String)this.name)), 16, 0xDDBB1D);
        if (!this.searchBox.isFocused() && this.searchBox.getText().isEmpty()) {
            this.field_146289_q.func_78276_b(this.searchLocal, this.getCenteredOffset(this.searchLocal), 88, 0xE0E0E0);
        }
        super.func_146979_b(x, y);
    }

    protected void buildOreList(String search) {
        this.oreList.removeAll();
        for (String oreName : LexiconManager.getSortedOreNames()) {
            if (!oreName.toLowerCase(Locale.US).contains(search.toLowerCase(Locale.US))) continue;
            this.oreList.add((IListBoxElement)new ListBoxElementText(oreName));
        }
    }

    protected void buildFullOreList() {
        this.oreList.removeAll();
        for (String oreName : LexiconManager.getSortedOreNames()) {
            this.oreList.add((IListBoxElement)new ListBoxElementText(oreName));
        }
    }
}

