/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidCore;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFluidRedstone
extends BlockFluidCore {
    public static final int LEVELS = 8;
    public static final Material materialFluidRedstone = new MaterialLiquid(MapColor.field_151645_D);
    private static boolean effect = true;

    public BlockFluidRedstone(Fluid fluid) {
        super(fluid, Material.field_151586_h, "thermalfoundation", "redstone");
        this.setQuantaPerBlock(8);
        this.setTickRate(5);
        this.func_149711_c(100.0f);
        this.func_149713_g(2);
        this.setParticleColor(0.4f, 0.0f, 0.0f);
    }

    public static void config() {
        String category = "Fluid.Redstone";
        String comment = "If TRUE, Fluid Redstone will emit a signal proportional to its fluid level.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    public boolean func_149744_f(IBlockState state) {
        return effect;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return effect ? this.func_176201_c(blockState) * 2 + 1 : 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidRedstone.getLuminosity();
    }

    public boolean initialize() {
        this.setRegistryName("fluid_redstone");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        BlockFluidRedstone.config();
        return true;
    }
}

