/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidCore;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFluidGlowstone
extends BlockFluidCore {
    public static final int LEVELS = 2;
    public static final Material materialFluidGlowstone = new MaterialLiquid(MapColor.field_151673_t);
    private static boolean effect = true;
    private static boolean enableSourceCondense = true;
    private static boolean enableSourceFloat = true;
    private static int maxHeight = 120;

    public BlockFluidGlowstone(Fluid fluid) {
        super(fluid, materialFluidGlowstone, "thermalfoundation", "glowstone");
        this.setQuantaPerBlock(2);
        this.setTickRate(10);
        this.func_149711_c(1.0f);
        this.func_149713_g(0);
        this.setParticleColor(1.0f, 0.9f, 0.05f);
    }

    public static void config() {
        String category = "Fluid.Glowstone";
        String comment = "If TRUE, Fluid Glowstone will provide buffs to entities on contact.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
        comment = "If TRUE, Fluid Glowstone Source blocks will condense back into solid Glowstone above a given y-value.";
        enableSourceCondense = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Condense", category, enableSourceCondense, comment);
        comment = "If TRUE, Fluid Glowstone Source blocks will gradually float upwards.";
        enableSourceFloat = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Float", category, enableSourceFloat, comment);
        comment = "This adjusts the y-value where Fluid Glowstone will *always* condense, if that is enabled. It will also condense above 80% of this value, if it cannot flow.";
        maxHeight = ThermalFoundation.CONFIG.getConfiguration().getInt("MaxHeight", category, maxHeight, maxHeight / 2, maxHeight * 2, comment);
    }

    private boolean shouldSourceBlockCondense(World world, BlockPos pos) {
        int y = pos.func_177956_o();
        return enableSourceCondense && (y + this.densityDir > maxHeight || y + this.densityDir > world.func_72800_K() || (float)(y + this.densityDir) > (float)maxHeight * 0.8f && !this.canDisplace((IBlockAccess)world, pos.func_177982_a(0, this.densityDir, 0)));
    }

    private boolean shouldSourceBlockFloat(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177982_a(0, this.densityDir, 0));
        return enableSourceFloat && state.func_177230_c() == this && state.func_177230_c().func_176201_c(state) != 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!effect) {
            return;
        }
        if (entity instanceof EntityLivingBase && entity.field_70181_x < -0.2) {
            entity.field_70181_x *= 0.5;
            entity.field_70143_R = entity.field_70143_R > 20.0f ? 20.0f : (float)((double)entity.field_70143_R * 0.95);
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 120, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 120, 0));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidGlowstone.getLuminosity();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.func_176201_c(state) == 0) {
            if (this.shouldSourceBlockCondense(world, pos)) {
                world.func_175656_a(pos, Blocks.field_150426_aN.func_176223_P());
                return;
            }
            if (rand.nextInt(3) == 0 && this.shouldSourceBlockFloat(world, pos)) {
                world.func_180501_a(pos.func_177982_a(0, this.densityDir, 0), this.func_176223_P(), 3);
                world.func_175698_g(pos);
                return;
            }
        } else if (pos.func_177956_o() > maxHeight) {
            world.func_175698_g(pos);
            return;
        }
        super.func_180650_b(world, pos, state, rand);
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta) {
        if (pos.func_177956_o() > maxHeight) {
            return;
        }
        super.flowIntoBlock(world, pos, meta);
    }

    public boolean initialize() {
        this.setRegistryName("fluid_glowstone");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        BlockFluidGlowstone.config();
        return true;
    }
}

