/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.api.block.IDismantleable;
import cofh.api.item.IToolHammer;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RAProps;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemWrenchRF
extends ItemShears
implements IEnergyContainerItem,
IEnchantableItem,
IToolHammer {
    protected int maxEnergy = 320000;
    protected int maxTransfer = 4000;
    protected int energyPerUse = 200;
    protected Item.ToolMaterial toolMaterial;
    protected boolean showInCreative = true;

    public ItemWrenchRF(Item.ToolMaterial toolMaterial) {
        this.toolMaterial = toolMaterial;
        this.func_77656_e(toolMaterial.func_77997_a());
        this.setNoRepair();
        this.setHarvestLevel("wrench", 1);
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.getEnergyStored(stack) > 0 ? 1.0f : 0.0f);
    }

    public ItemWrenchRF setEnergyParams(int maxEnergy, int maxTransfer, int energyPerUse) {
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.energyPerUse = energyPerUse;
        return this;
    }

    public ItemWrenchRF setShowInCreative(boolean showInCreative) {
        this.showInCreative = showInCreative;
        return this;
    }

    protected int getEnergyPerUse(ItemStack stack) {
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)4);
        return this.energyPerUse * (5 - unbreakingLevel) / 5;
    }

    protected int useEnergy(ItemStack stack, boolean simulate) {
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)4);
        return this.extractEnergy(stack, this.energyPerUse * (5 - unbreakingLevel) / 5, simulate);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.formatNumber((long)stack.func_77978_p().func_74762_e("Energy")) + " / " + StringHelper.formatNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add("\u00a76" + this.getEnergyPerUse(stack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        tooltip.add(StringHelper.getNoticeText((String)"info.redstonearsenal.tool.wrench"));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.showInCreative) {
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)0));
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)this.maxEnergy));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(0);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        entity.field_70177_z += 90.0f;
        entity.field_70177_z %= 360.0f;
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (ServerHelper.isClientWorld((World)entity.field_70170_p)) {
            entity.field_70177_z += 90.0f;
            entity.field_70177_z %= 360.0f;
            return false;
        }
        if (entity instanceof IShearable) {
            IShearable target = (IShearable)entity;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (target.isShearable(stack, (IBlockAccess)entity.field_70170_p, pos)) {
                List drops = target.onSheared(stack, (IBlockAccess)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                for (ItemStack drop : drops) {
                    EntityItem ent = entity.func_70099_a(drop, 1.0f);
                    ent.field_70181_x += (double)(MathHelper.RANDOM.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((MathHelper.RANDOM.nextFloat() - MathHelper.RANDOM.nextFloat()) * 0.1f);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    this.useEnergy(stack, false);
                }
                entity.field_70177_z += 90.0f;
                entity.field_70177_z %= 360.0f;
            }
            return true;
        }
        entity.field_70177_z += 90.0f;
        entity.field_70177_z %= 360.0f;
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        if (ServerHelper.isClientWorld((World)player.field_70170_p)) {
            return false;
        }
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(stack, (IBlockAccess)player.field_70170_p, pos)) {
            List drops = target.onSheared(stack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
            for (ItemStack drop : drops) {
                float f = 0.7f;
                double d = (double)(MathHelper.RANDOM.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(MathHelper.RANDOM.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(MathHelper.RANDOM.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drop);
                entityitem.func_174867_a(10);
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            player.func_71064_a(StatList.func_188055_a((Block)block), 1);
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !oldStack.func_77969_a(newStack) || this.getEnergyStored(oldStack) >= this.getEnergyStored(newStack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return RAProps.showToolCharge && stack.func_77978_p() != null && !stack.func_77978_p().func_74767_n("CreativeTab");
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ServerHelper.isClientWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(0);
        }
        if (!player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos)) {
            return EnumActionResult.PASS;
        }
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY || event.getUseItem() == Event.Result.DENY || event.getUseBlock() == Event.Result.DENY) {
            return EnumActionResult.PASS;
        }
        if (ServerHelper.isServerWorld((World)world) && player.func_70093_af() && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(world, pos, state, player)) {
            ((IDismantleable)block).dismantleBlock(world, pos, state, player, false);
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return EnumActionResult.SUCCESS;
        }
        if (BlockHelper.canRotate((Block)block)) {
            world.func_180501_a(pos, BlockHelper.rotateVanillaBlock((World)world, (IBlockState)state, (BlockPos)pos), 3);
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            player.func_184609_a(hand);
            return ServerHelper.isServerWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        if (!player.func_70093_af() && block.rotateBlock(world, pos, side)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            player.func_184609_a(hand);
            return ServerHelper.isServerWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Tool modifier", 1.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.4, 0));
        }
        return multimap;
    }

    public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        if (user instanceof EntityPlayer && ((EntityPlayer)user).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.getEnergyStored(item) >= this.getEnergyPerUse(item);
    }

    public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        if (user instanceof EntityPlayer && ((EntityPlayer)user).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.getEnergyStored(item) >= this.getEnergyPerUse(item);
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(player.func_184614_ca(), false);
            }
        }
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(player.func_184614_ca(), false);
            }
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.maxTransfer));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        if (container.func_77978_p().func_74764_b("Unbreakable")) {
            container.func_77978_p().func_82580_o("Unbreakable");
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)container);
        return this.maxEnergy + this.maxEnergy * enchant / 2;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public boolean canWhack(EntityPlayer player, EnumHand hand, ItemStack crowbar, BlockPos pos) {
        return this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar) || player.field_71075_bZ.field_75098_d;
    }

    public void onWhack(EntityPlayer player, EnumHand hand, ItemStack crowbar, BlockPos pos) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
    }

    public boolean canLink(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        return player.func_70093_af() && this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar) || player.field_71075_bZ.field_75098_d;
    }

    public void onLink(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
    }

    public boolean canBoost(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        return !player.func_70093_af() && this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar);
    }

    public void onBoost(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
    }

    public boolean canWrench(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        ItemStack stack = player.func_184614_ca();
        return this.getEnergyStored(stack) >= this.getEnergyPerUse(stack) || player.field_71075_bZ.field_75098_d;
    }

    public void wrenchUsed(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(player.func_184614_ca(), false);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

