/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.api.block.IDismantleable;
import cofh.api.item.IToolHammer;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.redstonearsenal.item.tool.ItemSwordRF;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemBattleWrenchRF
extends ItemSwordRF
implements IToolHammer {
    public ItemBattleWrenchRF(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.setHarvestLevel("wrench", 1);
        this.damage = 6;
        this.damageCharged = 3;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase player) {
        entity.field_70177_z += 90.0f;
        entity.field_70177_z %= 360.0f;
        return super.func_77644_a(stack, entity, player);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ServerHelper.isClientWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() > 0) {
            stack.func_77964_b(0);
        }
        if (!player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos)) {
            return EnumActionResult.PASS;
        }
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getResult() == Event.Result.DENY || event.getUseBlock() == Event.Result.DENY || event.getUseItem() == Event.Result.DENY) {
            return EnumActionResult.PASS;
        }
        if (ServerHelper.isServerWorld((World)world) && player.func_70093_af() && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(world, pos, state, player)) {
            ((IDismantleable)block).dismantleBlock(world, pos, state, player, false);
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return EnumActionResult.SUCCESS;
        }
        if (BlockHelper.canRotate((Block)block)) {
            world.func_180501_a(pos, BlockHelper.rotateVanillaBlock((World)world, (IBlockState)state, (BlockPos)pos), 3);
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            player.func_184609_a(hand);
            return ServerHelper.isServerWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        if (!player.func_70093_af() && block.rotateBlock(world, pos, side)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            player.func_184609_a(hand);
            return ServerHelper.isServerWorld((World)world) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        if (user instanceof EntityPlayer && ((EntityPlayer)user).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.getEnergyStored(item) >= this.getEnergyPerUse(item);
    }

    public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        if (user instanceof EntityPlayer && ((EntityPlayer)user).field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.getEnergyStored(item) >= this.getEnergyPerUse(item);
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(player.func_184614_ca(), false);
            }
        }
    }

    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(player.func_184614_ca(), false);
            }
        }
    }

    public boolean canWhack(EntityPlayer player, EnumHand hand, ItemStack crowbar, BlockPos pos) {
        return this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar) || player.field_71075_bZ.field_75098_d;
    }

    public void onWhack(EntityPlayer player, EnumHand hand, ItemStack crowbar, BlockPos pos) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
    }

    public boolean canLink(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        return player.func_70093_af() && this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar) || player.field_71075_bZ.field_75098_d;
    }

    public void onLink(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
    }

    public boolean canBoost(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        return !player.func_70093_af() && this.getEnergyStored(crowbar) >= this.getEnergyPerUse(crowbar);
    }

    public void onBoost(EntityPlayer player, EnumHand hand, ItemStack crowbar, EntityMinecart cart) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(crowbar, false);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
    }

    public boolean canWrench(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        ItemStack stack = player.func_184614_ca();
        return this.getEnergyStored(stack) >= this.getEnergyPerUse(stack) || player.field_71075_bZ.field_75098_d;
    }

    public void wrenchUsed(EntityPlayer player, EnumHand hand, ItemStack wrench, RayTraceResult rayTrace) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(player.func_184614_ca(), false);
        }
    }
}

