/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.Iterator;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.gui.GuiEventHandler;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.ingredients.IngredientLookupMemory;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.runtime.JeiHelpers;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.runtime.SubtypeRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.ModIngredientRegistration;
import mezz.jei.startup.ModRegistry;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.Log;
import net.minecraftforge.fml.common.ProgressManager;

public class JeiStarter {
    private boolean started;

    public void start(List<IModPlugin> plugins) {
        long jeiStartTime = System.currentTimeMillis();
        Log.get().info("Starting JEI...");
        SubtypeRegistry subtypeRegistry = new SubtypeRegistry();
        JeiStarter.registerItemSubtypes(plugins, subtypeRegistry);
        StackHelper stackHelper = new StackHelper(subtypeRegistry);
        stackHelper.enableUidCache();
        Internal.setStackHelper(stackHelper);
        IngredientRegistry ingredientRegistry = JeiStarter.registerIngredients(plugins);
        Internal.setIngredientRegistry(ingredientRegistry);
        JeiHelpers jeiHelpers = new JeiHelpers(ingredientRegistry, stackHelper);
        Internal.setHelpers(jeiHelpers);
        ModRegistry modRegistry = new ModRegistry(jeiHelpers, ingredientRegistry);
        JeiStarter.registerCategories(plugins, modRegistry);
        JeiStarter.registerPlugins(plugins, modRegistry);
        Log.get().info("Building recipe registry...");
        long start_time = System.currentTimeMillis();
        RecipeRegistry recipeRegistry = modRegistry.createRecipeRegistry(ingredientRegistry);
        Log.get().info("Built    recipe registry in {} ms", (Object)(System.currentTimeMillis() - start_time));
        Log.get().info("Loading ingredient lookup history...");
        start_time = System.currentTimeMillis();
        Internal.setIngredientLookupMemory(new IngredientLookupMemory(recipeRegistry, ingredientRegistry));
        Log.get().info("Loaded  ingredient lookup history in {} ms", (Object)(System.currentTimeMillis() - start_time));
        Log.get().info("Building ingredient list...");
        start_time = System.currentTimeMillis();
        List<IIngredientListElement> ingredientList = IngredientListElementFactory.createBaseList(ingredientRegistry, ForgeModIdHelper.getInstance());
        Log.get().info("Built    ingredient list in {} ms", (Object)(System.currentTimeMillis() - start_time));
        Log.get().info("Building ingredient filter...");
        start_time = System.currentTimeMillis();
        IngredientFilter ingredientFilter = new IngredientFilter(jeiHelpers);
        ingredientFilter.addIngredients(ingredientList);
        Internal.setIngredientFilter(ingredientFilter);
        Log.get().info("Built    ingredient filter in {} ms", (Object)(System.currentTimeMillis() - start_time));
        Log.get().info("Building runtime...");
        start_time = System.currentTimeMillis();
        List<IAdvancedGuiHandler<?>> advancedGuiHandlers = modRegistry.getAdvancedGuiHandlers();
        IngredientListOverlay ingredientListOverlay = new IngredientListOverlay(ingredientFilter, ingredientRegistry);
        RecipesGui recipesGui = new RecipesGui(recipeRegistry);
        JeiRuntime jeiRuntime = new JeiRuntime(recipeRegistry, ingredientListOverlay, recipesGui, ingredientRegistry, advancedGuiHandlers, ingredientFilter);
        Internal.setRuntime(jeiRuntime);
        Log.get().info("Built    runtime in {} ms", (Object)(System.currentTimeMillis() - start_time));
        stackHelper.disableUidCache();
        JeiStarter.sendRuntime(plugins, jeiRuntime);
        GuiEventHandler guiEventHandler = new GuiEventHandler(jeiRuntime);
        Internal.setGuiEventHandler(guiEventHandler);
        this.started = true;
        Log.get().info("Finished Starting JEI in {} ms", (Object)(System.currentTimeMillis() - jeiStartTime));
    }

    public boolean hasStarted() {
        return this.started;
    }

    private static void registerItemSubtypes(List<IModPlugin> plugins, SubtypeRegistry subtypeRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering item subtypes", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerItemSubtypes(subtypeRegistry);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register item subtypes for mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static IngredientRegistry registerIngredients(List<IModPlugin> plugins) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering ingredients", (int)plugins.size());
        ModIngredientRegistration modIngredientRegistry = new ModIngredientRegistration();
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                plugin.registerIngredients(modIngredientRegistry);
            }
            catch (LinkageError | RuntimeException e) {
                if (VanillaPlugin.class.isInstance(plugin)) {
                    throw e;
                }
                Log.get().error("Failed to register Ingredients for mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        return modIngredientRegistry.createIngredientRegistry();
    }

    private static void registerCategories(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering categories", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().info("Registering categories: {} ...", (Object)plugin.getClass().getName());
                plugin.registerCategories(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.get().info("Registered  categories: {} in {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (AbstractMethodError start_time) {
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register mod categories: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void registerPlugins(List<IModPlugin> plugins, ModRegistry modRegistry) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Registering plugins", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().info("Registering plugin: {} ...", (Object)plugin.getClass().getName());
                plugin.register(modRegistry);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                Log.get().info("Registered  plugin: {} in {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Failed to register mod plugin: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    private static void sendRuntime(List<IModPlugin> plugins, IJeiRuntime jeiRuntime) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Sending Runtime", (int)plugins.size());
        Iterator<IModPlugin> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IModPlugin plugin = iterator.next();
            try {
                progressBar.step(plugin.getClass().getName());
                long start_time = System.currentTimeMillis();
                Log.get().info("Sending runtime to plugin: {} ...", (Object)plugin.getClass().getName());
                plugin.onRuntimeAvailable(jeiRuntime);
                long timeElapsedMs = System.currentTimeMillis() - start_time;
                if (timeElapsedMs <= 100L) continue;
                Log.get().warn("Sending runtime to plugin: {} took {} ms", (Object)plugin.getClass().getName(), (Object)timeElapsedMs);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Sending runtime to plugin failed: {}", plugin.getClass(), (Object)e);
                iterator.remove();
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }
}

