/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IIngredientFilter;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import mezz.jei.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.HoverChecker;

public class DebugRecipe
implements IRecipeWrapper {
    private final GuiButtonExt button = new GuiButtonExt(0, 110, 30, "test");
    private final HoverChecker buttonHoverChecker;

    public DebugRecipe() {
        this.button.func_175211_a(40);
        this.buttonHoverChecker = new HoverChecker((GuiButton)this.button, 0);
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.button.func_191745_a(minecraft, mouseX, mouseY, minecraft.func_184121_ak());
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        FluidStack water = new FluidStack(FluidRegistry.WATER, 1000 + (int)(Math.random() * 1000.0));
        FluidStack lava = new FluidStack(FluidRegistry.LAVA, 1000 + (int)(Math.random() * 1000.0));
        ingredients.setInputs(FluidStack.class, Arrays.asList(water, lava));
        ingredients.setInput(ItemStack.class, new ItemStack(Items.field_151055_y));
        ingredients.setInputLists(DebugIngredient.class, Collections.singletonList(Arrays.asList(new DebugIngredient(0), new DebugIngredient(1))));
        ingredients.setOutputs(DebugIngredient.class, Arrays.asList(new DebugIngredient(2), new DebugIngredient(3)));
    }

    public List<FluidStack> getFluidInputs() {
        return Arrays.asList(new FluidStack(FluidRegistry.WATER, 1000 + (int)(Math.random() * 1000.0)), new FluidStack(FluidRegistry.LAVA, 1000 + (int)(Math.random() * 1000.0)));
    }

    @Override
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        ArrayList<String> tooltipStrings = new ArrayList<String>();
        if (this.buttonHoverChecker.checkHover(mouseX, mouseY)) {
            tooltipStrings.add("button tooltip!");
        } else {
            tooltipStrings.add(TextFormatting.BOLD + "tooltip debug");
        }
        tooltipStrings.add(mouseX + ", " + mouseY);
        return tooltipStrings;
    }

    @Override
    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.button.func_146116_c(minecraft, mouseX, mouseY)) {
            GuiInventory screen = new GuiInventory((EntityPlayer)minecraft.field_71439_g);
            minecraft.func_147108_a((GuiScreen)screen);
            IJeiRuntime runtime = JEIInternalPlugin.jeiRuntime;
            if (runtime != null) {
                IIngredientFilter ingredientFilter = runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
            }
            return true;
        }
        return false;
    }
}

