/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Keyboard;

public class GuiTextFieldFilter
extends GuiTextField {
    private static final int MAX_HISTORY = 100;
    private static final int maxSearchLength = 128;
    private static final List<String> history = new LinkedList<String>();
    private final HoverChecker hoverChecker;
    private final IngredientFilter ingredientFilter;
    private boolean previousKeyboardRepeatEnabled;

    public GuiTextFieldFilter(int componentId, IngredientFilter ingredientFilter) {
        super(componentId, Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0);
        this.func_146203_f(128);
        this.hoverChecker = new HoverChecker(0, 0, 0, 0, 0);
        this.ingredientFilter = ingredientFilter;
    }

    public void updateBounds(Rectangle area) {
        this.field_146209_f = area.x;
        this.field_146210_g = area.y;
        this.field_146218_h = area.width;
        this.field_146219_i = area.height;
        this.hoverChecker.updateBounds(area.y, area.y + area.height, area.x, area.x + area.width);
    }

    public void update() {
        this.func_146180_a(Config.getFilterText());
        List<IIngredientListElement> ingredientList = this.ingredientFilter.getIngredientList();
        if (ingredientList.size() == 0) {
            this.func_146193_g(Color.red.getRGB());
        } else {
            this.func_146193_g(Color.white.getRGB());
        }
    }

    public boolean func_146201_a(char typedChar, int keyCode) {
        boolean handled = super.func_146201_a(typedChar, keyCode);
        if (!handled && !history.isEmpty()) {
            if (keyCode == 200) {
                String currentText = this.func_146179_b();
                int historyIndex = history.indexOf(currentText);
                if (historyIndex < 0) {
                    historyIndex = this.saveHistory() ? history.size() - 1 : history.size();
                }
                if (historyIndex > 0) {
                    String historyString = history.get(historyIndex - 1);
                    this.func_146180_a(historyString);
                    handled = true;
                }
            } else if (keyCode == 208) {
                String currentText = this.func_146179_b();
                int historyIndex = history.indexOf(currentText);
                if (historyIndex >= 0) {
                    String historyString = historyIndex + 1 < history.size() ? history.get(historyIndex + 1) : "";
                    this.func_146180_a(historyString);
                    handled = true;
                }
            } else if (keyCode == 28) {
                this.saveHistory();
            }
        }
        return handled;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.func_146180_a("");
            return Config.setFilterText("");
        }
        super.func_146192_a(mouseX, mouseY, mouseButton);
        return false;
    }

    public void func_146195_b(boolean keyboardFocus) {
        boolean previousFocus = this.func_146206_l();
        super.func_146195_b(keyboardFocus);
        if (previousFocus != keyboardFocus) {
            if (keyboardFocus) {
                this.previousKeyboardRepeatEnabled = Keyboard.areRepeatEventsEnabled();
                Keyboard.enableRepeatEvents((boolean)true);
            } else {
                Keyboard.enableRepeatEvents((boolean)this.previousKeyboardRepeatEnabled);
            }
            this.saveHistory();
        }
    }

    private boolean saveHistory() {
        String text = this.func_146179_b();
        if (text.length() > 0) {
            history.remove(text);
            history.add(text);
            if (history.size() > 100) {
                history.remove(0);
            }
            return true;
        }
        return false;
    }
}

