/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.config.Config;
import mezz.jei.startup.ForgeModIdHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.HoverChecker;

public class RecipeInfoIcon {
    private static final IDrawable ICON = Internal.getHelpers().getGuiHelper().getInfoIcon();
    private final HoverChecker hoverChecker;

    public RecipeInfoIcon() {
        int iconTop = 0;
        int iconBottom = RecipeInfoIcon.getHeight();
        int iconLeft = 116 - RecipeInfoIcon.getWidth() * 2 - 1;
        int iconRight = iconLeft + RecipeInfoIcon.getWidth();
        this.hoverChecker = new HoverChecker(iconTop, iconBottom, iconLeft, iconRight, 0);
    }

    public static int getWidth() {
        return ICON.getWidth() / 2;
    }

    public static int getHeight() {
        return ICON.getHeight() / 2;
    }

    public void draw(Minecraft minecraft) {
        int iconX = 116 - RecipeInfoIcon.getWidth() * 2 - 1;
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        ICON.draw(minecraft, iconX * 2, 0);
        GlStateManager.func_179121_F();
    }

    public List<String> getTooltipStrings(ResourceLocation recipeRegistryName, int mouseX, int mouseY) {
        if (this.hoverChecker.checkHover(mouseX, mouseY)) {
            ArrayList<String> tooltipStrings = new ArrayList<String>();
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n()) {
                tooltipStrings.add(TextFormatting.GRAY + recipeRegistryName.func_110623_a());
            }
            String modNameFormat = Config.getModNameFormat();
            String modName = ForgeModIdHelper.getInstance().getModNameForModId(recipeRegistryName.func_110624_b());
            tooltipStrings.add(modNameFormat + modName);
            return tooltipStrings;
        }
        return Collections.emptyList();
    }
}

