/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import mezz.jei.Internal;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.IngredientLookupState;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.util.MathUtil;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    private final IRecipeRegistry recipeRegistry;
    private final IRecipeLogicStateListener stateListener;
    private boolean initialState = true;
    private IngredientLookupState state;
    private final Stack<IngredientLookupState> history = new Stack();
    private List<IRecipeWrapper> recipes = Collections.emptyList();

    public RecipeGuiLogic(IRecipeRegistry recipeRegistry, IRecipeLogicStateListener stateListener) {
        this.recipeRegistry = recipeRegistry;
        this.stateListener = stateListener;
        List<IRecipeCategory> recipeCategories = recipeRegistry.getRecipeCategories();
        this.state = new IngredientLookupState(null, recipeCategories, 0, 0);
    }

    @Override
    public <V> boolean setFocus(IFocus<V> focus) {
        List<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories(focus = Focus.check(focus));
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (!this.initialState) {
            this.history.push(this.state);
        }
        IngredientLookupState state = Internal.getIngredientLookupMemory().getState(focus, recipeCategories);
        this.setState(state);
        return true;
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        IngredientLookupState state = this.history.pop();
        this.setState(state);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private void setState(IngredientLookupState state) {
        this.state = state;
        this.initialState = false;
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public boolean setCategoryFocus() {
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        if (!this.initialState) {
            this.history.push(this.state);
        }
        List<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories();
        int recipeCategoryIndex = recipeCategories.indexOf(recipeCategory);
        IngredientLookupState state = new IngredientLookupState(null, recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    @Override
    public boolean setCategoryFocus(List<String> recipeCategoryUids) {
        List<IRecipeCategory> recipeCategories = this.recipeRegistry.getRecipeCategories(recipeCategoryUids);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (!this.initialState) {
            this.history.push(this.state);
        }
        IngredientLookupState state = new IngredientLookupState(null, recipeCategories, 0, 0);
        this.setState(state);
        return true;
    }

    @Override
    public List<Object> getRecipeCatalysts() {
        IRecipeCategory category = this.getSelectedRecipeCategory();
        return this.getRecipeCatalysts(category);
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory recipeCategory) {
        return this.recipeRegistry.getRecipeCatalysts(recipeCategory);
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state.getRecipesPerPage() != recipesPerPage) {
            this.state.setRecipesPerPage(recipesPerPage);
            this.updateRecipes();
        }
    }

    private void updateRecipes() {
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        IFocus<?> focus = this.state.getFocus();
        this.recipes = focus != null ? this.recipeRegistry.getRecipeWrappers(recipeCategory, focus) : this.recipeRegistry.getRecipeWrappers(recipeCategory);
    }

    @Override
    public IRecipeCategory getSelectedRecipeCategory() {
        return (IRecipeCategory)this.state.getRecipeCategories().get(this.state.getRecipeCategoryIndex());
    }

    @Override
    public ImmutableList<IRecipeCategory> getRecipeCategories() {
        return this.state.getRecipeCategories();
    }

    @Override
    public List<RecipeLayout> getRecipeLayouts(int posX, int posY, int spacingY) {
        int firstRecipeIndex;
        ArrayList<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        int recipeWidgetIndex = 0;
        int recipePosY = posY;
        for (int recipeIndex = firstRecipeIndex = this.state.getRecipeIndex() - this.state.getRecipeIndex() % this.state.getRecipesPerPage(); recipeIndex < this.recipes.size() && recipeLayouts.size() < this.state.getRecipesPerPage(); ++recipeIndex) {
            RecipeLayout recipeLayout;
            IRecipeWrapper recipeWrapper = this.recipes.get(recipeIndex);
            if ((recipeLayout = RecipeLayout.create(recipeWidgetIndex++, recipeCategory, recipeWrapper, this.state.getFocus(), posX, recipePosY)) == null) {
                this.recipes.remove(recipeIndex);
                this.recipeRegistry.removeRecipe(recipeWrapper, recipeCategory.getUid());
                --recipeIndex;
                continue;
            }
            recipeLayouts.add(recipeLayout);
            recipePosY += spacingY;
        }
        return recipeLayouts;
    }

    @Override
    public void nextRecipeCategory() {
        int recipesTypesCount = this.state.getRecipeCategories().size();
        this.state.setRecipeCategoryIndex((this.state.getRecipeCategoryIndex() + 1) % recipesTypesCount);
        this.state.setRecipeIndex(0);
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public void setRecipeCategory(IRecipeCategory category) {
        int index = this.state.getRecipeCategories().indexOf((Object)category);
        if (index < 0) {
            return;
        }
        this.state.setRecipeCategoryIndex(index);
        this.state.setRecipeIndex(0);
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public boolean hasMultiplePages() {
        return this.recipes.size() > this.state.getRecipesPerPage();
    }

    @Override
    public void previousRecipeCategory() {
        int recipesTypesCount = this.state.getRecipeCategories().size();
        this.state.setRecipeCategoryIndex((recipesTypesCount + this.state.getRecipeCategoryIndex() - 1) % recipesTypesCount);
        this.state.setRecipeIndex(0);
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public void nextPage() {
        this.state.setRecipeIndex(this.state.getRecipeIndex() + this.state.getRecipesPerPage());
        if (this.state.getRecipeIndex() >= this.recipes.size()) {
            this.state.setRecipeIndex(0);
        }
        this.stateListener.onStateChange();
    }

    @Override
    public void previousPage() {
        this.state.setRecipeIndex(this.state.getRecipeIndex() - this.state.getRecipesPerPage());
        if (this.state.getRecipeIndex() < 0) {
            int pageCount = this.pageCount(this.state.getRecipesPerPage());
            this.state.setRecipeIndex((pageCount - 1) * this.state.getRecipesPerPage());
        }
        this.stateListener.onStateChange();
    }

    private int pageCount(int recipesPerPage) {
        if (this.recipes.size() <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(this.recipes.size(), recipesPerPage);
    }

    @Override
    public String getPageString() {
        int pageIndex = MathUtil.divideCeil(this.state.getRecipeIndex() + 1, this.state.getRecipesPerPage());
        return pageIndex + "/" + this.pageCount(this.state.getRecipesPerPage());
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state.getRecipeCategories().size() > 1;
    }

    @Override
    public boolean hasAllCategories() {
        return this.state.getRecipeCategories().size() == this.recipeRegistry.getRecipeCategories().size();
    }
}

