/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Table;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.Config;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.IngredientLookupState;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.FileUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;

public class IngredientLookupMemory {
    private final Table<IFocus.Mode, String, IngredientLookupState> mostRecentLookups = HashBasedTable.create();
    private final Table<IFocus.Mode, String, RecipeLookupFromFile> mostRecentLookupsFromFile = HashBasedTable.create();
    private final RecipeRegistry recipeRegistry;
    private final IIngredientRegistry ingredientRegistry;
    private final Object saveLock = new Object();
    private boolean needsSaving = false;
    private boolean saving = false;

    public IngredientLookupMemory(RecipeRegistry recipeRegistry, IIngredientRegistry ingredientRegistry) {
        this.recipeRegistry = recipeRegistry;
        this.ingredientRegistry = ingredientRegistry;
        this.readFromFile();
    }

    public <T> IngredientLookupState getState(IFocus<T> focus, List<IRecipeCategory> recipeCategories) {
        Set<Integer> indexesForOpenContainer;
        int categoryIndex;
        RecipeLookupFromFile stateFromFile;
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        focus = Focus.check(focus);
        IFocus.Mode focusMode = focus.getMode();
        T value = focus.getValue();
        IIngredientHelper<T> ingredientHelper = this.ingredientRegistry.getIngredientHelper(value);
        String uniqueId = ingredientHelper.getUniqueId(value);
        IngredientLookupState state = (IngredientLookupState)this.mostRecentLookups.get((Object)focusMode, (Object)uniqueId);
        if (state == null && (stateFromFile = (RecipeLookupFromFile)this.mostRecentLookupsFromFile.get((Object)focusMode, (Object)uniqueId)) != null && (categoryIndex = this.getRecipeCategoryIndex(recipeCategories, stateFromFile.categoryUid)) >= 0) {
            IRecipeCategory recipeCategory = recipeCategories.get(categoryIndex);
            if (stateFromFile.recipeIndex < this.recipeRegistry.getRecipeWrappers(recipeCategory, focus).size()) {
                state = new IngredientLookupState(focus, recipeCategories, categoryIndex, stateFromFile.recipeIndex);
            }
        }
        if (state == null) {
            state = new IngredientLookupState(focus, recipeCategories, 0, 0);
        }
        if (!(indexesForOpenContainer = this.getRecipeCategoryIndexesForOpenContainer((List<IRecipeCategory>)state.getRecipeCategories())).isEmpty() && !indexesForOpenContainer.contains(state.getRecipeCategoryIndex())) {
            Integer index = Collections.min(indexesForOpenContainer);
            state.setRecipeCategoryIndex(index);
        }
        if (this.mostRecentLookups.put((Object)focusMode, (Object)uniqueId, (Object)state) != state) {
            this.markDirty();
        }
        if (this.mostRecentLookupsFromFile.remove((Object)focusMode, (Object)uniqueId) != null) {
            this.markDirty();
        }
        return state;
    }

    private Set<Integer> getRecipeCategoryIndexesForOpenContainer(List<IRecipeCategory> recipeCategories) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player != null) {
            GuiScreen screen;
            Container container = player.field_71070_bA;
            if (container != null) {
                for (int i = 0; i < recipeCategories.size(); ++i) {
                    IRecipeCategory recipeCategory = recipeCategories.get(i);
                    if (this.recipeRegistry.getRecipeTransferHandler(container, recipeCategory) == null) continue;
                    indexes.add(i);
                }
            }
            if ((screen = minecraft.field_71462_r) instanceof RecipesGui) {
                RecipesGui recipesGui = (RecipesGui)screen;
                screen = recipesGui.getParentScreen();
            }
            if (screen instanceof GuiContainer) {
                GuiContainer guiContainer = (GuiContainer)screen;
                ImmutableCollection<RecipeClickableArea> clickableAreas = this.recipeRegistry.getAllRecipeClickableAreas(guiContainer);
                HashSet<String> recipeCategoryUids = new HashSet<String>();
                for (RecipeClickableArea clickableArea : clickableAreas) {
                    recipeCategoryUids.addAll(clickableArea.getRecipeCategoryUids());
                }
                for (int i = 0; i < recipeCategories.size(); ++i) {
                    IRecipeCategory recipeCategory = recipeCategories.get(i);
                    if (!recipeCategoryUids.contains(recipeCategory.getUid())) continue;
                    indexes.add(i);
                }
            }
        }
        return indexes;
    }

    private int getRecipeCategoryIndex(List<IRecipeCategory> recipeCategories, String recipeCategoryUid) {
        for (int i = 0; i < recipeCategories.size(); ++i) {
            IRecipeCategory recipeCategory = recipeCategories.get(i);
            if (!recipeCategory.getUid().equals(recipeCategoryUid)) continue;
            return i;
        }
        return -1;
    }

    private void readFromFile() {
        File file = new File(Config.getJeiConfigurationDir(), "lookupHistory.zip");
        FileUtil.readZipFileSafely(file, "lookupHistory.json", zipInputStream -> {
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(zipInputStream));
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (!name.equals("lookupStates")) continue;
                this.readLookupStatesObject(jsonReader);
            }
            jsonReader.endObject();
        });
    }

    private void readLookupStatesObject(JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String focusModeName = jsonReader.nextName();
            IFocus.Mode focusMode = IFocus.Mode.valueOf(focusModeName);
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                String ingredientString = jsonReader.nextString();
                String category = jsonReader.nextString();
                int recipeIndex = jsonReader.nextInt();
                jsonReader.endArray();
                RecipeLookupFromFile recipeLookupFromFile = new RecipeLookupFromFile(category, recipeIndex);
                this.mostRecentLookupsFromFile.put((Object)focusMode, (Object)ingredientString, (Object)recipeLookupFromFile);
            }
            jsonReader.endArray();
        }
        jsonReader.endObject();
    }

    public void markDirty() {
        this.needsSaving = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile() {
        Object object = this.saveLock;
        synchronized (object) {
            if (this.needsSaving && !this.saving) {
                this.saving = true;
                this.needsSaving = false;
                this.saveToFileAsync();
            }
        }
    }

    private void saveToFileAsync() {
        HashBasedTable mostRecentLookups = HashBasedTable.create(this.mostRecentLookups);
        HashBasedTable mostRecentLookupsFromFile = HashBasedTable.create(this.mostRecentLookupsFromFile);
        new Thread(() -> this.lambda$saveToFileAsync$7((Table)mostRecentLookups, (Table)mostRecentLookupsFromFile)).start();
    }

    private static void saveToFileSync(Table<IFocus.Mode, String, IngredientLookupState> mostRecentLookups, Table<IFocus.Mode, String, RecipeLookupFromFile> mostRecentLookupsFromFile) {
        File file = new File(Config.getJeiConfigurationDir(), "lookupHistory.zip");
        boolean write = FileUtil.writeZipFileSafely(file, "lookupHistory.json", zipOutputStream -> {
            JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter(zipOutputStream));
            jsonWriter.beginObject();
            IngredientLookupMemory.writeLookupStatesObject(jsonWriter, mostRecentLookups, mostRecentLookupsFromFile);
            jsonWriter.endObject();
            jsonWriter.flush();
        });
        if (write) {
            Log.get().debug("Saved IngredientLookupMemory to {}.", (Object)file.getAbsoluteFile());
        }
    }

    private static void writeLookupStatesObject(JsonWriter jsonWriter, Table<IFocus.Mode, String, IngredientLookupState> mostRecentLookups, Table<IFocus.Mode, String, RecipeLookupFromFile> mostRecentLookupsFromFile) throws IOException {
        jsonWriter.name("lookupStates").beginObject();
        for (IFocus.Mode focusMode : IFocus.Mode.values()) {
            Object state;
            String ingredientString;
            jsonWriter.name(focusMode.toString()).beginArray();
            for (Map.Entry lookups : mostRecentLookups.row((Object)focusMode).entrySet()) {
                ingredientString = (String)lookups.getKey();
                state = (IngredientLookupState)lookups.getValue();
                int recipeCategoryIndex = ((IngredientLookupState)state).getRecipeCategoryIndex();
                String categoryUid = ((IRecipeCategory)((IngredientLookupState)state).getRecipeCategories().get(recipeCategoryIndex)).getUid();
                jsonWriter.beginArray().value(ingredientString).value(categoryUid).value((long)((IngredientLookupState)state).getRecipeIndex()).endArray();
            }
            for (Map.Entry lookups : mostRecentLookupsFromFile.row((Object)focusMode).entrySet()) {
                ingredientString = (String)lookups.getKey();
                state = (RecipeLookupFromFile)lookups.getValue();
                jsonWriter.beginArray().value(ingredientString).value(((RecipeLookupFromFile)state).categoryUid).value((long)((RecipeLookupFromFile)state).recipeIndex).endArray();
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$saveToFileAsync$7(Table mostRecentLookups, Table mostRecentLookupsFromFile) {
        IngredientLookupMemory.saveToFileSync((Table<IFocus.Mode, String, IngredientLookupState>)mostRecentLookups, (Table<IFocus.Mode, String, RecipeLookupFromFile>)mostRecentLookupsFromFile);
        Object object = this.saveLock;
        synchronized (object) {
            this.saving = false;
        }
    }

    private static class RecipeLookupFromFile {
        private final String categoryUid;
        private final int recipeIndex;

        public RecipeLookupFromFile(String categoryUid, int recipeIndex) {
            this.categoryUid = categoryUid;
            this.recipeIndex = recipeIndex;
        }
    }
}

