/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayTracer {
    public static RayTraceResult retrace(EntityPlayer player) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach) {
        return RayTracer.retrace(player, reach, true);
    }

    public static RayTraceResult retrace(EntityPlayer player, boolean stopOnFluid) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player);
        return player.field_70170_p.func_147447_a(startVec, endVec, stopOnFluid, false, true);
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach, boolean stopOnFluids) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player, reach);
        return player.field_70170_p.func_147447_a(startVec, endVec, stopOnFluids, false, true);
    }

    public static RayTraceResult retraceBlock(World world, EntityPlayer player, BlockPos pos) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player);
        return world.func_180495_p(pos).func_185910_a(world, pos, startVec, endVec);
    }

    public static Vec3d getStartVec(EntityPlayer player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static Vec3d getEndVec(EntityPlayer player) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }

    public static Vec3d getEndVec(EntityPlayer player, double reach) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }

    public static Vec3d getCorrectedHeadVec(EntityPlayer player) {
        return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistanceClient() : (player instanceof EntityPlayerMP ? RayTracer.getBlockReachDistanceServer((EntityPlayerMP)player) : 5.0);
    }

    private static double getBlockReachDistanceServer(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistanceClient() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }
}

