/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.proxy;

import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.item.tool.ItemShieldCore;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.key.KeyHandlerCore;
import cofh.core.util.core.IBowImproved;
import cofh.core.util.core.IQuiverItem;
import cofh.core.util.helpers.MathHelper;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Proxy {
    public void preInit(FMLPreInitializationEvent event) {
    }

    public void initialize(FMLInitializationEvent event) {
        this.registerKeyBinds();
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    public void registerKeyBinds() {
        KeyHandlerCore.addServerKeyBind(KeyBindingItemMultiMode.INSTANCE);
    }

    public int getKeyBind(String key) {
        return 0;
    }

    public void addIndexedChatMessage(ITextComponent chat, int index) {
    }

    public boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public boolean isQuiver(ItemStack stack) {
        return stack.func_77973_b() instanceof IQuiverItem;
    }

    public EntityArrow createArrow(World world, ItemStack stack, EntityPlayer player) {
        if (this.isArrow(stack)) {
            return ((ItemArrow)stack.func_77973_b()).func_185052_a(world, stack, (EntityLivingBase)player);
        }
        if (this.isQuiver(stack)) {
            return ((IQuiverItem)stack.func_77973_b()).createEntityArrow(world, stack, (EntityLivingBase)player);
        }
        return ((ItemArrow)Items.field_151032_g).func_185052_a(world, stack, (EntityLivingBase)player);
    }

    public ItemStack findAmmo(EntityPlayer player) {
        ItemStack offHand = player.func_184592_cb();
        ItemStack mainHand = player.func_184614_ca();
        if (this.isQuiver(offHand) && !((IQuiverItem)offHand.func_77973_b()).isEmpty(offHand, (EntityLivingBase)player) || this.isArrow(offHand)) {
            return offHand;
        }
        if (this.isQuiver(mainHand) && !((IQuiverItem)mainHand.func_77973_b()).isEmpty(mainHand, (EntityLivingBase)player) || this.isArrow(mainHand)) {
            return mainHand;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if ((!this.isQuiver(stack) || ((IQuiverItem)stack.func_77973_b()).isEmpty(stack, (EntityLivingBase)player)) && !this.isArrow(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean isOp(String playerName) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        playerName = playerName.trim();
        for (String a : server.func_184103_al().func_152606_n()) {
            if (!playerName.equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isServer() {
        return true;
    }

    public World getClientWorld() {
        return null;
    }

    public IThreadListener getClientListener() {
        return null;
    }

    public IThreadListener getServerListener() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public EntityPlayer findPlayer(String player) {
        return null;
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    public List<EntityPlayer> getPlayerList() {
        LinkedList<EntityPlayer> result = new LinkedList<EntityPlayer>();
        for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++i) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i] == null) continue;
            result.addAll(FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i].field_73010_i);
        }
        return result;
    }

    public void updateFriendListGui() {
    }

    public float getSoundVolume(int category) {
        return 0.0f;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleArrowLooseEvent(ArrowLooseEvent event) {
        boolean flag;
        if (!(event.getBow().func_77973_b() instanceof ItemBow)) {
            return;
        }
        ItemStack stack = event.getBow();
        IBowImproved bowImproved = null;
        EntityPlayer player = event.getEntityPlayer();
        ItemStack arrowStack = this.findAmmo(player);
        World world = event.getWorld();
        if (stack.func_77973_b() instanceof IBowImproved) {
            bowImproved = (IBowImproved)stack.func_77973_b();
        }
        boolean bl = flag = player.field_71075_bZ.field_75098_d || arrowStack.func_77973_b() instanceof ItemArrow && ((ItemArrow)arrowStack.func_77973_b()).isInfinite(arrowStack, stack, player);
        if (!arrowStack.func_190926_b() || flag) {
            float speedMod;
            if (arrowStack.func_190926_b()) {
                arrowStack = new ItemStack(Items.field_151032_g);
            }
            float f = ItemBow.func_185059_b((int)event.getCharge());
            float f2 = speedMod = bowImproved != null ? 1.0f + bowImproved.getArrowSpeedMultiplier() : 1.0f;
            if ((double)f >= 0.1) {
                if (!world.field_72995_K) {
                    boolean encFlame;
                    int encMultishot = MathHelper.clamp(EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.multishot, (ItemStack)stack), 0, 10);
                    int encPunch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
                    int encPower = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                    boolean bl2 = encFlame = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0;
                    if (bowImproved != null) {
                        bowImproved.onBowFired(player, stack);
                    }
                    for (int shot = 0; shot <= encMultishot; ++shot) {
                        EntityArrow arrow = this.createArrow(world, arrowStack, player);
                        arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f * speedMod, 1.0f + (1.5f - f) * (float)shot);
                        if (bowImproved != null) {
                            arrow.func_70239_b(arrow.func_70242_d() * (double)(1.0f + bowImproved.getArrowDamageMultiplier()));
                        }
                        if (f >= 1.0f) {
                            arrow.func_70243_d(true);
                        }
                        if (encPower > 0) {
                            arrow.func_70239_b(arrow.func_70242_d() + (double)encPower * 0.5 + 0.5);
                        }
                        if (encPunch > 0) {
                            arrow.func_70240_a(encPunch);
                        }
                        if (encFlame) {
                            arrow.func_70015_d(100);
                        }
                        if (flag) {
                            arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_72838_d((Entity)arrow);
                    }
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!flag && !player.field_71075_bZ.field_75098_d) {
                    if (this.isQuiver(arrowStack)) {
                        ((IQuiverItem)arrowStack.func_77973_b()).onArrowFired(arrowStack, (EntityLivingBase)player);
                    } else {
                        arrowStack.func_190918_g(1);
                        if (arrowStack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(arrowStack);
                        }
                    }
                }
                player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleArrowNockEvent(ArrowNockEvent event) {
        if (!(event.getBow().func_77973_b() instanceof ItemBow)) {
            return;
        }
        ItemStack stack = event.getBow();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack arrowStack = this.findAmmo(player);
        if (arrowStack.func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0) {
            arrowStack = new ItemStack(Items.field_151032_g);
        }
        if (!arrowStack.func_190926_b()) {
            player.func_184598_c(event.getHand());
            event.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)stack));
        } else if (!player.field_71075_bZ.field_75098_d) {
            event.setAction(new ActionResult(EnumActionResult.FAIL, (Object)stack));
        }
    }

    @SubscribeEvent
    public void handleLivingAttackEvent(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && !(player = (EntityPlayer)event.getEntityLiving()).func_184607_cu().func_190926_b()) {
            ItemStack stack = player.func_184607_cu();
            float damage = event.getAmount();
            if (damage >= 3.0f && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemShieldCore) {
                ((ItemShieldCore)stack.func_77973_b()).damageShield(stack, 1 + MathHelper.floor(damage), player, event.getSource().func_76346_g());
                if (stack.func_190916_E() <= 0) {
                    EnumHand enumhand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)player.field_184627_bm, (EnumHand)enumhand);
                    if (enumhand == EnumHand.MAIN_HAND) {
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    } else {
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    }
                    player.field_184627_bm = ItemStack.field_190927_a;
                    player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!CoreProps.enableLivingEntityDeathMessages || entity.field_70170_p.field_72995_K || !(entity instanceof EntityLiving) || !event.getEntityLiving().func_145818_k_()) {
            return;
        }
        entity.field_70170_p.func_73046_m().func_184103_al().func_148539_a(event.getEntityLiving().func_110142_aN().func_151521_b());
    }

    @SubscribeEvent
    public void handleLivingDropsEvent(LivingDropsEvent event) {
    }
}

