/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element.tab;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IReconfigurableSides;
import cofh.core.gui.GuiCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.init.CoreTextures;
import cofh.core.render.ISidedTexture;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class TabConfiguration
extends TabBase {
    public static int defaultSide = 1;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColor = 0x226688;
    private IReconfigurableFacing myTileFacing;
    private IReconfigurableSides myTileSides;
    private ISidedTexture myTileTexture;

    public TabConfiguration(GuiCore gui, IReconfigurableSides theTile) {
        this(gui, defaultSide, theTile);
    }

    public TabConfiguration(GuiCore gui, int side, IReconfigurableSides theTile) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myTileSides = theTile;
        this.myTileFacing = (IReconfigurableFacing)((Object)theTile);
        this.myTileTexture = (ISidedTexture)((Object)theTile);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.configuration"));
        }
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            mouseX += this.currentWidth;
        }
        if ((mouseX -= this.currentShiftX) < 16 || mouseX >= 80 || (mouseY -= this.currentShiftY) < 20 || mouseY >= 84) {
            return false;
        }
        if (40 <= mouseX && mouseX < 56 && 24 <= mouseY && mouseY < 40) {
            this.handleSideChange(BlockHelper.SIDE_ABOVE[this.myTileFacing.getFacing()], mouseButton);
        } else if (20 <= mouseX && mouseX < 36 && 44 <= mouseY && mouseY < 60) {
            this.handleSideChange(BlockHelper.SIDE_LEFT[this.myTileFacing.getFacing()], mouseButton);
        } else if (40 <= mouseX && mouseX < 56 && 44 <= mouseY && mouseY < 60) {
            this.handleSideChange(this.myTileFacing.getFacing(), mouseButton);
        } else if (60 <= mouseX && mouseX < 76 && 44 <= mouseY && mouseY < 60) {
            this.handleSideChange(BlockHelper.SIDE_RIGHT[this.myTileFacing.getFacing()], mouseButton);
        } else if (40 <= mouseX && mouseX < 56 && 64 <= mouseY && mouseY < 80) {
            this.handleSideChange(BlockHelper.SIDE_BELOW[this.myTileFacing.getFacing()], mouseButton);
        } else if (60 <= mouseX && mouseX < 76 && 64 <= mouseY && mouseY < 80) {
            this.handleSideChange(BlockHelper.SIDE_OPPOSITE[this.myTileFacing.getFacing()], mouseButton);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(this.posX() + 16, this.posY + 20, 16, 20, 64, 64);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon(CoreTextures.ICON_CONFIG);
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.configuration"), (float)(this.posXOffset() + 18), (float)(this.posY + 6), this.headerColor);
        RenderHelper.setBlockTextureSheet();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        for (int pass = 0; pass < this.myTileTexture.getNumPasses(); ++pass) {
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_ABOVE[this.myTileFacing.getFacing()], pass), this.posX() + 40, this.posY + 24);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_LEFT[this.myTileFacing.getFacing()], pass), this.posX() + 20, this.posY + 44);
            this.gui.drawIcon(this.myTileTexture.getTexture(this.myTileFacing.getFacing(), pass), this.posX() + 40, this.posY + 44);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_RIGHT[this.myTileFacing.getFacing()], pass), this.posX() + 60, this.posY + 44);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_BELOW[this.myTileFacing.getFacing()], pass), this.posX() + 40, this.posY + 64);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_OPPOSITE[this.myTileFacing.getFacing()], pass), this.posX() + 60, this.posY + 64);
        }
        GlStateManager.func_179084_k();
        RenderHelper.setDefaultFontTextureSheet();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    void handleSideChange(int side, int mouseButton) {
        if (GuiScreen.func_146272_n()) {
            if (side == this.myTileFacing.getFacing()) {
                if (this.myTileSides.resetSides()) {
                    GuiCore.playClickSound(0.2f);
                }
            } else if (this.myTileSides.setSide(side, 0)) {
                GuiCore.playClickSound(0.4f);
            }
            return;
        }
        if (mouseButton == 0) {
            if (this.myTileSides.incrSide(side)) {
                GuiCore.playClickSound(0.8f);
            }
        } else if (mouseButton == 1 && this.myTileSides.decrSide(side)) {
            GuiCore.playClickSound(0.6f);
        }
    }
}

