/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element.tab;

import cofh.core.gui.GuiCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.tab.TabTracker;
import cofh.core.util.Rectangle4i;
import cofh.core.util.helpers.RenderHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public abstract class TabBase
extends ElementBase {
    public static int tabExpandSpeed = 8;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    protected int offsetX = 0;
    protected int offsetY = 0;
    public boolean open;
    public boolean fullyOpen;
    public int side = 1;
    public int headerColor = 14797103;
    public int subheaderColor = 11186104;
    public int textColor = 0;
    public int backgroundColor = 0xFFFFFF;
    protected int currentShiftX = 0;
    protected int currentShiftY = 0;
    public int minWidth = 22;
    public int maxWidth = 124;
    public int currentWidth = this.minWidth;
    public int minHeight = 22;
    public int maxHeight = 22;
    public int currentHeight = this.minHeight;
    protected ArrayList<ElementBase> elements = new ArrayList();
    public static final ResourceLocation DEFAULT_TEXTURE_LEFT = new ResourceLocation("cofh:textures/gui/elements/tab_left.png");
    public static final ResourceLocation DEFAULT_TEXTURE_RIGHT = new ResourceLocation("cofh:textures/gui/elements/tab_right.png");

    public TabBase(GuiCore gui) {
        super(gui, 0, 0);
        this.texture = DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase(GuiCore gui, int side) {
        super(gui, 0, 0);
        this.side = side;
        this.texture = side == 0 ? DEFAULT_TEXTURE_LEFT : DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase setOffsets(int x, int y) {
        this.posX -= this.offsetX;
        this.posY -= this.offsetY;
        this.offsetX = x;
        this.offsetY = y;
        this.posX += this.offsetX;
        this.posY += this.offsetY;
        return this;
    }

    @Override
    public TabBase setPosition(int posX, int posY) {
        this.posX = posX + this.offsetX;
        this.posY = posY + this.offsetY;
        return this;
    }

    protected void drawForeground() {
    }

    protected void drawBackground() {
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        RenderHelper.bindTexture(this.texture);
        int xPosition = this.posX();
        this.gui.func_73729_b(xPosition, this.posY + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
        this.gui.func_73729_b(xPosition + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
        this.gui.func_73729_b(xPosition, this.posY, 0, 0, 4, 4);
        this.gui.func_73729_b(xPosition + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        mouseX -= this.posX();
        mouseY -= this.posY;
        GlStateManager.func_179094_E();
        this.drawBackground();
        GlStateManager.func_179109_b((float)this.posX(), (float)this.posY, (float)0.0f);
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase element = this.elements.get(i);
            if (!element.isVisible()) continue;
            element.drawBackground(mouseX, mouseY, gameTicks);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        mouseX -= this.posX();
        mouseY -= this.posY;
        GlStateManager.func_179094_E();
        this.drawForeground();
        GlStateManager.func_179109_b((float)this.posX(), (float)this.posY, (float)0.0f);
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase element = this.elements.get(i);
            if (!element.isVisible()) continue;
            element.drawForeground(mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        mouseX -= this.posX();
        mouseY -= this.posY;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled()) continue;
            c.update(mouseX, mouseY);
        }
    }

    @Override
    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += tabExpandSpeed;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= tabExpandSpeed;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += tabExpandSpeed;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= tabExpandSpeed;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
        if (!this.fullyOpen && this.open && this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    protected void drawTabIcon(TextureAtlasSprite iconName) {
        this.gui.drawIcon(iconName, this.posXOffset(), this.posY + 3);
    }

    protected int posX() {
        if (this.side == 0) {
            return this.posX - this.currentWidth;
        }
        return this.posX;
    }

    protected int posXOffset() {
        return this.posX() + this.sideOffset();
    }

    protected int sideOffset() {
        return this.side == 0 ? 4 : 2;
    }

    public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
        return this.side == 0 ? mouseX <= shiftX && mouseX >= shiftX - this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.currentHeight : mouseX >= (shiftX += this.offsetX) && mouseX <= shiftX + this.currentWidth && mouseY >= (shiftY += this.offsetY) && mouseY <= shiftY + this.currentHeight;
    }

    public boolean isFullyOpened() {
        return this.fullyOpen;
    }

    public void setCurrentShift(int x, int y) {
        this.updateElements();
        this.currentShiftX = x + this.offsetX;
        this.currentShiftY = y + this.offsetY;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
        this.fullyOpen = true;
        this.updateElements();
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(null);
            } else {
                TabTracker.setOpenedRightTab(null);
            }
            this.fullyOpen = false;
        } else {
            this.open = true;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(this.getClass());
            } else {
                TabTracker.setOpenedRightTab(this.getClass());
            }
        }
        this.updateElements();
    }

    public Rectangle4i getBounds() {
        if (this.isVisible()) {
            return new Rectangle4i(this.posX() + this.gui.getGuiLeft(), this.posY + this.gui.getGuiTop(), this.currentWidth, this.currentHeight);
        }
        return new Rectangle4i(this.posX() + this.gui.getGuiLeft(), this.posY + this.gui.getGuiTop(), 0, 0);
    }

    public ElementBase addElement(ElementBase element) {
        this.elements.add(element);
        return element;
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = this.elements.get(i);
            if (!element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    @Override
    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        int wheelMovement = Mouse.getEventDWheel();
        mouseX -= this.posX();
        mouseY -= this.posY;
        if (wheelMovement != 0) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY) || !c.onMouseWheel(mouseX, mouseY, wheelMovement)) continue;
                return true;
            }
        }
        return true;
    }

    @Override
    public void addTooltip(List<String> list) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(this.gui.getMouseX(), this.gui.getMouseY())) continue;
            c.addTooltip(list);
        }
    }

    @Override
    public boolean onKeyTyped(char characterTyped, int keyPressed) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.onKeyTyped(characterTyped, keyPressed)) continue;
            return true;
        }
        return super.onKeyTyped(characterTyped, keyPressed);
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) throws IOException {
        mouseX -= this.posX();
        mouseY -= this.posY;
        boolean shouldStayOpen = false;
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mouseX, mouseY)) continue;
            shouldStayOpen = true;
            if (!c.onMousePressed(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return shouldStayOpen;
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        mouseX -= this.posX();
        mouseY -= this.posY;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled()) continue;
            c.onMouseReleased(mouseX, mouseY);
        }
    }

    protected void updateElements() {
        for (ElementBase element : this.elements) {
            element.setVisible(this.isFullyOpened());
        }
    }
}

