/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.core.gui.GuiCore;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class ElementBase {
    protected GuiCore gui;
    protected ResourceLocation texture;
    private FontRenderer fontRenderer;
    protected int posX;
    protected int posY;
    protected int sizeX;
    protected int sizeY;
    protected int texW = 256;
    protected int texH = 256;
    protected String name;
    private boolean visible = true;
    private boolean enabled = true;

    public ElementBase(GuiCore gui, int posX, int posY) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
    }

    public ElementBase(GuiCore gui, int posX, int posY, int width, int height) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.sizeX = width;
        this.sizeY = height;
    }

    public ElementBase setName(String name) {
        this.name = name;
        return this;
    }

    public ElementBase setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        return this;
    }

    public ElementBase setSize(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        return this;
    }

    public ElementBase setTexture(String texture, int texW, int texH) {
        this.texture = new ResourceLocation(texture);
        this.texW = texW;
        this.texH = texH;
        return this;
    }

    public final ElementBase setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final ElementBase setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(int mouseX, int mouseY) {
        this.update();
    }

    public void update() {
    }

    public abstract void drawBackground(int var1, int var2, float var3);

    public abstract void drawForeground(int var1, int var2);

    public void addTooltip(List<String> list) {
    }

    public void drawModalRect(int x, int y, int width, int height, int color) {
        this.gui.drawSizedModalRect(x, y, width, height, color);
    }

    public void drawStencil(int xStart, int yStart, int xEnd, int yEnd, int flag) {
        GlStateManager.func_179090_x();
        GL11.glStencilFunc((int)519, (int)flag, (int)flag);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)flag);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179132_a((boolean)false);
        GL11.glClearStencil((int)0);
        GlStateManager.func_179086_m((int)1024);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)xStart, (double)yEnd, 0.0).func_181675_d();
        buffer.func_181662_b((double)xEnd, (double)yEnd, 0.0).func_181675_d();
        buffer.func_181662_b((double)xEnd, (double)yStart, 0.0).func_181675_d();
        buffer.func_181662_b((double)xStart, (double)yStart, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GL11.glStencilFunc((int)514, (int)flag, (int)flag);
        GL11.glStencilMask((int)0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179132_a((boolean)true);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.gui.drawSizedTexturedModalRect(x, y, u, v, width, height, this.texW, this.texH);
    }

    public void drawCenteredString(FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_175063_a(text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) throws IOException {
        return false;
    }

    public void onMouseReleased(int mouseX, int mouseY) {
    }

    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        return false;
    }

    public boolean onKeyTyped(char characterTyped, int keyPressed) {
        return false;
    }

    public boolean intersectsWith(int mouseX, int mouseY) {
        return mouseX >= this.posX && mouseX <= this.posX + this.sizeX && mouseY >= this.posY && mouseY <= this.posY + this.sizeY;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer == null ? this.gui.getFontRenderer() : this.fontRenderer;
    }

    public ElementBase setFontRenderer(FontRenderer renderer) {
        this.fontRenderer = renderer;
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public final GuiCore getContainerScreen() {
        return this.gui;
    }

    public final int getPosY() {
        return this.posY;
    }

    public final int getPosX() {
        return this.posX;
    }

    public final int getHeight() {
        return this.sizeY;
    }

    public final int getWidth() {
        return this.sizeX;
    }
}

