/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.bitbag.BagCapabilityProvider;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.bitbag.BagStorage;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketOpenBagGui;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemBitBag
extends Item {
    public static final int INTS_PER_BIT_TYPE = 2;
    public static final int OFFSET_STATE_ID = 0;
    public static final int OFFSET_QUANTITY = 1;
    SimpleInstanceCache<ItemStack, List<String>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public ItemBitBag() {
        this.func_77625_d(1);
        ChiselsAndBits.registerWithBus((Object)this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BagCapabilityProvider(stack, nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        List<String> details;
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpBitBag, tooltip, new String[0]);
        if (this.tooltipCache.needsUpdate(stack)) {
            BagInventory bi = new BagInventory(stack);
            this.tooltipCache.updateCachedValue(bi.listContents(new ArrayList<String>()));
        }
        if ((details = this.tooltipCache.getCached()).size() <= 2 || ClientSide.instance.holdingShift()) {
            tooltip.addAll(details);
        } else {
            tooltip.add(LocalStrings.ShiftDetails.getLocal());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            NetworkRouter.instance.sendToServer(new PacketOpenBagGui());
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @SubscribeEvent
    public void pickupItems(EntityItemPickupEvent event) {
        boolean modified = false;
        EntityItem entityItem = event.getItem();
        if (entityItem != null) {
            ItemStack is = entityItem.func_92059_d();
            EntityPlayer player = event.getEntityPlayer();
            if (is != null && is.func_77973_b() instanceof ItemChiseledBit) {
                int originalSize = ModUtil.getStackSize(is);
                InventoryPlayer inv = player.field_71071_by;
                List<BagPos> bags = ItemBitBag.getBags((IInventory)inv);
                boolean seen = ModUtil.containsAtLeastOneOf((IInventory)inv, is);
                if (seen) {
                    for (BagPos i : bags) {
                        if (entityItem.field_70128_L) continue;
                        modified = this.updateEntity(player, entityItem, i.inv.insertItem(ModUtil.nonNull(entityItem.func_92059_d())), originalSize) || modified;
                    }
                } else {
                    if (ModUtil.getStackSize(is) > is.func_77976_d() && !entityItem.field_70128_L) {
                        ItemStack singleStack = is.func_77946_l();
                        ModUtil.setStackSize(singleStack, singleStack.func_77976_d());
                        if (!player.field_71071_by.func_70441_a(singleStack)) {
                            ModUtil.adjustStackSize(is, -(singleStack.func_77976_d() - ModUtil.getStackSize(is)));
                        }
                    } else {
                        return;
                    }
                    modified = this.updateEntity(player, entityItem, is, originalSize) || modified;
                    for (BagPos i : bags) {
                        if (entityItem.field_70128_L) continue;
                        modified = this.updateEntity(player, entityItem, i.inv.insertItem(ModUtil.nonNull(entityItem.func_92059_d())), originalSize) || modified;
                    }
                }
            }
            ItemBitBag.cleanupInventory(player, is);
        }
        if (modified) {
            event.setCanceled(true);
        }
    }

    private boolean updateEntity(EntityPlayer player, EntityItem ei, ItemStack is, int originalSize) {
        if (is == null) {
            is = new ItemStack(ei.func_92059_d().func_77973_b(), 0);
            ei.func_92058_a(is);
            ei.func_70106_y();
            FMLCommonHandler.instance().firePlayerItemPickupEvent(player, ei);
            if (!ei.func_174814_R()) {
                ei.field_70170_p.func_184148_a((EntityPlayer)null, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            player.func_71001_a((Entity)ei, originalSize);
            return true;
        }
        int changed = ModUtil.getStackSize(is) - ModUtil.getStackSize(ei.func_92059_d());
        ei.func_92058_a(is);
        return changed != 0;
    }

    @SubscribeEvent
    public void pickupItems(PlayerEvent.ItemPickupEvent event) {
        EntityItem ei = event.pickedUp;
        if (ei != null) {
            ItemBitBag.cleanupInventory(event.player, ei.func_92059_d());
        }
    }

    public static void cleanupInventory(EntityPlayer player, ItemStack is) {
        if (is != null && is.func_77973_b() instanceof ItemChiseledBit) {
            InventoryPlayer inv = player.field_71071_by;
            List<BagPos> bags = ItemBitBag.getBags((IInventory)inv);
            int firstSeen = -1;
            block0: for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                int actingSlot = slot;
                ItemStack which = ModUtil.nonNull(inv.func_70301_a(actingSlot));
                if (which == null || which.func_77973_b() != is.func_77973_b() || !ItemChiseledBit.sameBit(which, ItemChiseledBit.getStackState(is)) && is.func_77952_i() != Short.MAX_VALUE) continue;
                if (actingSlot == player.field_71071_by.field_70461_c) {
                    if (firstSeen == -1) continue;
                    actingSlot = firstSeen;
                }
                which = ModUtil.nonNull(inv.func_70301_a(actingSlot));
                if (firstSeen == -1) {
                    firstSeen = actingSlot;
                    continue;
                }
                for (BagPos i : bags) {
                    if (!ModUtil.isEmpty(which = i.inv.insertItem(which))) continue;
                    inv.func_70299_a(actingSlot, which);
                    continue block0;
                }
            }
        }
    }

    public static List<BagPos> getBags(IInventory inv) {
        ArrayList<BagPos> bags = new ArrayList<BagPos>();
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack which = inv.func_70301_a(x);
            if (which == null || !(which.func_77973_b() instanceof ItemBitBag)) continue;
            bags.add(new BagPos(new BagInventory(which)));
        }
        return bags;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        Object o = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (o instanceof BagStorage) {
            int qty = ((BagStorage)o).getSlotsUsed();
            return qty != 0;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        Object o = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (o instanceof BagStorage) {
            int qty = ((BagStorage)o).getSlotsUsed();
            double value = (float)qty / 63.0f;
            return Math.min(1.0, Math.max(0.0, ChiselsAndBits.getConfig().invertBitBagFullness ? value : 1.0 - value));
        }
        return 0.0;
    }

    public static class BagPos {
        public final BagInventory inv;

        public BagPos(BagInventory bagInventory) {
            this.inv = bagInventory;
        }
    }
}

