/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.gui;

import com.google.common.base.Predicate;
import com.google.common.primitives.Floats;
import forestry.api.climate.IClimateControlProvider;
import forestry.api.climate.IClimateInfo;
import forestry.api.multiblock.IGreenhouseController;
import forestry.core.climate.ClimateInfo;
import forestry.core.gui.TextLayoutHelper;
import forestry.core.network.packets.PacketUpdateClimateControl;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.greenhouse.gui.GuiGreenhouse;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class ClimateTextFields {
    private final GuiTextField humidityField;
    private final GuiTextField temperatureField;
    private final IClimateControlProvider provider;
    protected static final Predicate<String> NUMBER_FILTER = text -> {
        if (text == null) {
            return false;
        }
        if (!text.isEmpty() && text.length() > 1 && !text.contains(".")) {
            return false;
        }
        if (text.length() > 7) {
            return false;
        }
        Float f = Floats.tryParse((String)text);
        return text.isEmpty() || f != null && Floats.isFinite((float)f.floatValue()) && f.floatValue() >= 0.0f;
    };

    public ClimateTextFields(IGreenhouseController controller, FontRenderer fontRenderer, int guiLeft, int guiTop) {
        this.provider = controller;
        IClimateInfo info = controller.getControlClimate();
        this.temperatureField = new GuiTextField(0, fontRenderer, guiLeft + 64, guiTop + 31, 50, 10);
        this.temperatureField.func_175205_a(NUMBER_FILTER);
        this.temperatureField.func_146185_a(false);
        this.temperatureField.func_146180_a(Float.toString(info.getTemperature()));
        this.humidityField = new GuiTextField(1, fontRenderer, guiLeft + 64, guiTop + 61, 50, 10);
        this.humidityField.func_175205_a(NUMBER_FILTER);
        this.humidityField.func_146185_a(false);
        this.humidityField.func_146180_a(Float.toString(info.getHumidity()));
    }

    protected boolean keyTyped(char typedChar, int keyCode) {
        return this.humidityField.func_146201_a(typedChar, keyCode) || this.temperatureField.func_146201_a(typedChar, keyCode);
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean temperatureWasFocused = this.temperatureField.func_146206_l();
        boolean humidityWasFocused = this.humidityField.func_146206_l();
        this.temperatureField.func_146192_a(mouseX, mouseY, mouseButton);
        this.humidityField.func_146192_a(mouseX, mouseY, mouseButton);
        if (temperatureWasFocused && !this.temperatureField.func_146206_l() || humidityWasFocused && !this.humidityField.func_146206_l()) {
            float temp = ClimateTextFields.parseField(this.temperatureField);
            float hum = ClimateTextFields.parseField(this.humidityField);
            this.setClimate(this.provider, temp, hum);
        }
        NetworkUtil.sendToServer(new PacketUpdateClimateControl(this.provider));
    }

    public void draw(GuiGreenhouse gui, int guiLeft, int guiTop) {
        TextLayoutHelper textLayout = gui.getTextLayout();
        gui.func_73729_b(guiLeft + 62, guiTop + 29, 204, 115, 52, 12);
        gui.func_73729_b(guiLeft + 62, guiTop + 59, 204, 127, 52, 12);
        textLayout.line = 20;
        textLayout.drawCenteredLine(Translator.translateToLocal("for.gui.temperature"), 0, ColourProperties.INSTANCE.get("gui.greenhouse.temperature.text"));
        this.temperatureField.func_146194_f();
        textLayout.line = 50;
        textLayout.drawCenteredLine(Translator.translateToLocal("for.gui.humidity"), 0, ColourProperties.INSTANCE.get("gui.greenhouse.humidity.text"));
        this.humidityField.func_146194_f();
    }

    public void setClimate(float temp) {
        IClimateInfo info = this.provider.getControlClimate();
        this.setClimate(this.provider, temp, info.getHumidity());
    }

    public void setClimate(IClimateControlProvider provider, float temp, float hum) {
        this.temperatureField.func_146180_a(Float.toString(temp));
        this.humidityField.func_146180_a(Float.toString(hum));
        provider.setControlClimate(new ClimateInfo(temp, hum));
    }

    private static float parseField(GuiTextField field) {
        String text = field.func_146179_b();
        if (text.isEmpty()) {
            return 2.0f;
        }
        try {
            float f = Float.parseFloat(text);
            if (f >= 2.0f) {
                f = 2.0f;
            }
            return f;
        }
        catch (NumberFormatException var5) {
            return 2.0f;
        }
    }
}

