/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.FarmLogic;
import forestry.farming.logic.FarmableCocoa;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmLogicCocoa
extends FarmLogic {
    private final IFarmable cocoa = new FarmableCocoa();
    private final Map<BlockPos, Integer> lastExtentsCultivation = new HashMap<BlockPos, Integer>();
    private final Map<BlockPos, Integer> lastExtentsHarvest = new HashMap<BlockPos, Integer>();

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151100_aR, 1, 3);
    }

    @Override
    public String getName() {
        return "Cocoa Plantation";
    }

    @Override
    public int getFertilizerConsumption() {
        return 120;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return this.cocoa.isGermling(itemstack);
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (!this.lastExtentsCultivation.containsKey(pos)) {
            this.lastExtentsCultivation.put(pos, 0);
        }
        if ((lastExtent = this.lastExtentsCultivation.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, lastExtent);
        boolean result = this.tryPlantingCocoa(world, farmHousing, position);
        this.lastExtentsCultivation.put(pos, ++lastExtent);
        return result;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (!this.lastExtentsHarvest.containsKey(pos)) {
            this.lastExtentsHarvest.put(pos, 0);
        }
        if ((lastExtent = this.lastExtentsHarvest.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(world, position);
        this.lastExtentsHarvest.put(pos, ++lastExtent);
        return crops;
    }

    private boolean tryPlantingCocoa(World world, IFarmHousing farmHousing, BlockPos position) {
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos(position);
        IBlockState blockState = world.func_180495_p((BlockPos)current);
        while (FarmLogicCocoa.isJungleTreeTrunk(blockState)) {
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                BlockPos candidate = new BlockPos(current.func_177958_n() + direction.func_82601_c(), current.func_177956_o(), current.func_177952_p() + direction.func_82599_e());
                if (!world.func_175623_d(candidate)) continue;
                return farmHousing.plantGermling(this.cocoa, world, candidate);
            }
            current.func_189536_c(EnumFacing.UP);
            if (current.func_177956_o() - position.func_177956_o() > 1) break;
            blockState = world.func_180495_p((BlockPos)current);
        }
        return false;
    }

    private static boolean isJungleTreeTrunk(IBlockState blockState) {
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150364_r && blockState.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE;
    }

    private Collection<ICrop> getHarvestBlocks(World world, BlockPos position) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        ICrop crop = null;
        if (!block.isWood((IBlockAccess)world, position) && (crop = this.cocoa.getCropAt(world, position, blockState)) == null) {
            return crops;
        }
        if (crop != null) {
            crops.add(crop);
        }
        List<BlockPos> candidates = this.processHarvestBlock(world, crops, seen, position, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(world, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(World world, Stack<ICrop> crops, Set<BlockPos> seen, BlockPos start, BlockPos position) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos candidate = position.func_177982_a(i, j, k);
                    if (candidate.equals((Object)position) || Math.abs(candidate.func_177958_n() - start.func_177958_n()) > 5 || Math.abs(candidate.func_177952_p() - start.func_177952_p()) > 5 || seen.contains(candidate)) continue;
                    IBlockState blockState = world.func_180495_p(candidate);
                    ICrop crop = this.cocoa.getCropAt(world, candidate, blockState);
                    if (crop != null) {
                        crops.push(crop);
                        candidates.add(candidate);
                        seen.add(candidate);
                        continue;
                    }
                    if (!blockState.func_177230_c().isWood((IBlockAccess)world, candidate)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }
}

