/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryResource;
import forestry.core.tiles.TileNaturalistChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RenderNaturalistChest
extends TileEntitySpecialRenderer<TileNaturalistChest> {
    private final ModelChest chestModel = new ModelChest();
    private final ResourceLocation texture;

    public RenderNaturalistChest(String textureName) {
        this.texture = new ForestryResource("textures/blocks/" + textureName + ".png");
    }

    public void render(TileNaturalistChest chest, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState blockState;
        World worldObj;
        if (chest != null && (worldObj = chest.getWorldObj()).func_175667_e(chest.func_174877_v()) && (blockState = worldObj.func_180495_p(chest.func_174877_v())).func_177230_c() instanceof BlockBase) {
            EnumFacing facing = (EnumFacing)blockState.func_177229_b(BlockBase.FACING);
            this.render(facing, chest.prevLidAngle, chest.lidAngle, x, y, z, partialTicks);
            return;
        }
        this.render(EnumFacing.SOUTH, 0.0f, 0.0f, x, y, z, 0.0f);
    }

    public void render(EnumFacing orientation, float prevLidAngle, float lidAngle, double x, double y, double z, float partialTick) {
        int rotation;
        GlStateManager.func_179094_E();
        this.func_147499_a(this.texture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        switch (orientation) {
            case EAST: {
                rotation = -90;
                break;
            }
            case NORTH: {
                rotation = 180;
                break;
            }
            case WEST: {
                rotation = 90;
                break;
            }
            default: {
                rotation = 0;
            }
        }
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float angle = prevLidAngle + (lidAngle - prevLidAngle) * partialTick;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        this.chestModel.field_78234_a.field_78795_f = -(angle * (float)Math.PI / 2.0f);
        this.chestModel.func_78231_a();
        GlStateManager.func_179121_F();
    }
}

