/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models.baker;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.IModelBakerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ModelBakerModel
implements IModelBakerModel {
    private boolean isGui3d;
    private boolean isAmbientOcclusion;
    private TextureAtlasSprite particleSprite;
    @Nullable
    private IModelState modelState;
    @Nullable
    private ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final Map<EnumFacing, List<BakedQuad>> faceQuads;
    private final List<BakedQuad> generalQuads;
    private final List<Pair<IBlockState, IBakedModel>> models;
    private float[] rotation = ModelBakerModel.getDefaultRotation();
    private float[] translation = ModelBakerModel.getDefaultTranslation();
    private float[] scale = ModelBakerModel.getDefaultScale();

    public ModelBakerModel(IModelState modelState) {
        this.models = new ArrayList<Pair<IBlockState, IBakedModel>>();
        this.faceQuads = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
        this.generalQuads = new ArrayList<BakedQuad>();
        this.particleSprite = Minecraft.func_71410_x().func_147117_R().field_94249_f;
        this.isGui3d = true;
        this.isAmbientOcclusion = false;
        this.setModelState(modelState);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.faceQuads.put(face, new ArrayList());
        }
    }

    private ModelBakerModel(List<Pair<IBlockState, IBakedModel>> models, Map<EnumFacing, List<BakedQuad>> faceQuads, List<BakedQuad> generalQuads, boolean isGui3d, boolean isAmbientOcclusion, IModelState modelState, float[] rotation, float[] translation, float[] scale, TextureAtlasSprite particleSprite) {
        this.models = models;
        this.faceQuads = faceQuads;
        this.generalQuads = generalQuads;
        this.isGui3d = isGui3d;
        this.isAmbientOcclusion = isAmbientOcclusion;
        this.rotation = rotation;
        this.translation = translation;
        this.scale = scale;
        this.particleSprite = particleSprite;
        this.setModelState(modelState);
    }

    @Override
    public void setGui3d(boolean gui3d) {
        this.isGui3d = gui3d;
    }

    public boolean func_177556_c() {
        return this.isGui3d;
    }

    @Override
    public void setAmbientOcclusion(boolean ambientOcclusion) {
        this.isAmbientOcclusion = ambientOcclusion;
    }

    public boolean func_177555_b() {
        return this.isAmbientOcclusion;
    }

    @Override
    public void setParticleSprite(TextureAtlasSprite particleSprite) {
        this.particleSprite = particleSprite;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleSprite;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private static float[] getDefaultRotation() {
        return new float[]{-80.0f, -45.0f, 170.0f};
    }

    private static float[] getDefaultTranslation() {
        return new float[]{0.0f, 1.5f, -2.75f};
    }

    private static float[] getDefaultScale() {
        return new float[]{0.375f, 0.375f, 0.375f};
    }

    @Override
    public void setRotation(float[] rotation) {
        this.rotation = rotation;
    }

    @Override
    public void setTranslation(float[] translation) {
        this.translation = translation;
    }

    @Override
    public void setScale(float[] scale) {
        this.scale = scale;
    }

    @Override
    public float[] getRotation() {
        return this.rotation;
    }

    @Override
    public float[] getTranslation() {
        return this.translation;
    }

    @Override
    public float[] getScale() {
        return this.scale;
    }

    public void setModelState(@Nullable IModelState modelState) {
        this.modelState = modelState;
        this.transforms = PerspectiveMapWrapper.getTransforms((IModelState)modelState);
    }

    public void addModelQuads(Pair<IBlockState, IBakedModel> model) {
        this.models.add(model);
    }

    @Override
    public void addQuad(@Nullable EnumFacing facing, BakedQuad quad) {
        if (facing != null) {
            this.faceQuads.get(facing).add(quad);
        } else {
            this.generalQuads.add(quad);
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Pair<IBlockState, IBakedModel> model : this.models) {
            List modelQuads = ((IBakedModel)model.getRight()).func_188616_a((IBlockState)model.getLeft(), side, rand);
            if (modelQuads.isEmpty()) continue;
            quads.addAll(modelQuads);
        }
        if (side != null) {
            quads.addAll((Collection)this.faceQuads.get(side));
        }
        quads.addAll(this.generalQuads);
        return quads;
    }

    public ModelBakerModel copy() {
        return new ModelBakerModel(this.models, this.faceQuads, this.generalQuads, this.isGui3d, this.isAmbientOcclusion, this.modelState, this.rotation, this.translation, this.scale, this.particleSprite);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

