/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.PluginCore;
import forestry.core.blocks.IBlockWithMeta;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBogEarth
extends Block
implements IItemModelRegister,
IBlockWithMeta {
    private static final int maturityDelimiter = 3;
    public static final PropertyInteger MATURITY = PropertyInteger.func_177719_a((String)"maturity", (int)0, (int)3);

    public BlockBogEarth() {
        super(Material.field_151578_c);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(CreativeTabForestry.tabForestry);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MATURITY, (Comparable)Integer.valueOf(0)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MATURITY);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MATURITY, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MATURITY});
    }

    public int func_149738_a(World world) {
        return 500;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Integer maturity = (Integer)state.func_177229_b((IProperty)MATURITY);
        SoilType type = SoilType.fromMaturity(maturity);
        if (type == SoilType.PEAT) {
            drops.add((Object)PluginCore.getItems().peat.getItemStack(2));
            drops.add((Object)new ItemStack(Blocks.field_150346_d));
        } else {
            drops.add((Object)new ItemStack((Block)this, 1, SoilType.BOG_EARTH.ordinal()));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || world.field_73012_v.nextInt(13) != 0) {
            return;
        }
        Integer maturity = (Integer)state.func_177229_b((IProperty)MATURITY);
        SoilType type = SoilType.fromMaturity(maturity);
        if (type == SoilType.BOG_EARTH && BlockBogEarth.isMoistened(world, pos)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)MATURITY, (Comparable)Integer.valueOf(maturity + 1)), 2);
        }
    }

    private static boolean isMoistened(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos waterPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, 2, 2))) {
            IBlockState blockState = world.func_180495_p((BlockPos)waterPos);
            Block block = blockState.func_177230_c();
            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
            return true;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public static SoilType getTypeFromState(IBlockState state) {
        Integer maturity = (Integer)state.func_177229_b((IProperty)MATURITY);
        return SoilType.fromMaturity(maturity);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "soil/bog");
        manager.registerItemModel(item, 1, "soil/bog");
        manager.registerItemModel(item, 2, "soil/bog");
        manager.registerItemModel(item, 3, "soil/peat");
    }

    @Override
    public String getNameFromMeta(int meta) {
        SoilType type = SoilType.fromMaturity(meta);
        return type.func_176610_l();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack get(SoilType soilType, int amount) {
        return new ItemStack((Block)this, amount, soilType.ordinal());
    }

    public static enum SoilType implements IStringSerializable
    {
        BOG_EARTH("bog_earth"),
        PEAT("peat");

        private final String name;

        private SoilType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static SoilType fromMaturity(int maturity) {
            if (maturity >= 3) {
                return PEAT;
            }
            return BOG_EARTH;
        }
    }
}

