/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.base.Preconditions;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.recipes.RecipeManagers;
import forestry.core.PluginCore;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemRegistryCore;
import forestry.core.items.ItemRegistryFluids;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ForestryPlugin(pluginID="forestry.fluids", name="Fluids", author="mezz", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.fluids.description")
public class PluginFluids
extends BlankForestryPlugin {
    @Nullable
    private static ItemRegistryFluids items;

    private static void createFluid(Fluids fluidDefinition) {
        String fluidName;
        if (fluidDefinition.getFluid() == null && Config.isFluidEnabled(fluidDefinition) && !FluidRegistry.isFluidRegistered((String)(fluidName = fluidDefinition.getTag()))) {
            ResourceLocation[] resources = fluidDefinition.getResources();
            Fluid fluid = new Fluid(fluidName, resources[0], fluidDefinition.flowTextureExists() ? resources[1] : resources[0]);
            fluid.setDensity(fluidDefinition.getDensity());
            fluid.setViscosity(fluidDefinition.getViscosity());
            fluid.setTemperature(fluidDefinition.getTemperature());
            FluidRegistry.registerFluid((Fluid)fluid);
            PluginFluids.createBlock(fluidDefinition);
        }
    }

    private static void createBlock(Fluids forestryFluid) {
        Fluid fluid = forestryFluid.getFluid();
        Preconditions.checkState((fluid != null ? 1 : 0) != 0);
        Block fluidBlock = fluid.getBlock();
        if (Config.isBlockEnabled(forestryFluid.getTag())) {
            if (fluidBlock == null) {
                fluidBlock = forestryFluid.makeBlock();
                if (fluidBlock != null) {
                    String name = "fluid." + forestryFluid.getTag();
                    fluidBlock.func_149663_c("forestry." + name);
                    fluidBlock.setRegistryName(name);
                    ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)fluidBlock);
                    ItemBlock itemBlock = new ItemBlock(fluidBlock);
                    itemBlock.setRegistryName(name);
                    ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
                    Proxies.render.registerFluidStateMapper(fluidBlock, forestryFluid);
                    if (forestryFluid.getOtherContainers().isEmpty()) {
                        FluidRegistry.addBucketForFluid((Fluid)fluid);
                    }
                }
            } else {
                ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)fluidBlock);
                Log.warning("Pre-existing {} fluid block detected, deferring to {}:{}, this may cause issues if the server/client have different mod load orders, recommended that you disable all but one instance of {} fluid blocks via your configs.", fluid.getName(), resourceLocation.func_110624_b(), resourceLocation.func_110623_a(), fluid.getName());
            }
        }
    }

    public static ItemRegistryFluids getItems() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    @Override
    public void registerItemsAndBlocks() {
        for (Fluids fluidType : Fluids.values()) {
            PluginFluids.createFluid(fluidType);
        }
        items = new ItemRegistryFluids();
    }

    @Override
    public void doInit() {
        if (RecipeManagers.squeezerManager != null) {
            ItemRegistryCore itemRegistryCore = PluginCore.getItems();
            RecipeManagers.squeezerManager.addContainerRecipe(10, PluginFluids.getItems().canEmpty.getItemStack(), itemRegistryCore.ingotTin.func_77946_l(), 0.05f);
            RecipeManagers.squeezerManager.addContainerRecipe(10, PluginFluids.getItems().waxCapsuleEmpty.getItemStack(), itemRegistryCore.beeswax.getItemStack(), 0.1f);
            RecipeManagers.squeezerManager.addContainerRecipe(10, PluginFluids.getItems().refractoryEmpty.getItemStack(), itemRegistryCore.refractoryWax.getItemStack(), 0.1f);
        }
        FluidStack ethanol = Fluids.BIO_ETHANOL.getFluid(1);
        GeneratorFuel ethanolFuel = new GeneratorFuel(ethanol, (int)(32.0f * ForestryAPI.activeMode.getFloatSetting("fuel.ethanol.generator")), 4);
        FuelManager.generatorFuel.put(ethanol.getFluid(), ethanolFuel);
        FluidStack biomass = Fluids.BIOMASS.getFluid(1);
        GeneratorFuel biomassFuel = new GeneratorFuel(biomass, (int)(8.0f * ForestryAPI.activeMode.getFloatSetting("fuel.biomass.generator")), 1);
        FuelManager.generatorFuel.put(biomass.getFluid(), biomassFuel);
    }
}

