/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.apiculture.PluginApiculture;
import forestry.core.genetics.BreedingTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class ApiaristTracker
extends BreedingTracker
implements IApiaristTracker {
    private int queensTotal = 0;
    private int dronesTotal = 0;
    private int princessesTotal = 0;

    public ApiaristTracker(String s) {
        super(s, PluginApiculture.beekeepingMode);
    }

    @Override
    public void func_76184_a(NBTTagCompound nbttagcompound) {
        this.queensTotal = nbttagcompound.func_74762_e("QueensTotal");
        this.princessesTotal = nbttagcompound.func_74762_e("PrincessesTotal");
        this.dronesTotal = nbttagcompound.func_74762_e("DronesTotal");
        super.func_76184_a(nbttagcompound);
    }

    @Override
    public NBTTagCompound func_189551_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("QueensTotal", this.queensTotal);
        nbttagcompound.func_74768_a("PrincessesTotal", this.princessesTotal);
        nbttagcompound.func_74768_a("DronesTotal", this.dronesTotal);
        nbttagcompound = super.func_189551_b(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void registerPickup(IIndividual individual) {
        ISpeciesRoot speciesRoot = individual.getGenome().getPrimary().getRoot();
        if (!speciesRoot.getUID().equals(this.speciesRootUID())) {
            return;
        }
        if (!individual.isPureBred(EnumBeeChromosome.SPECIES)) {
            return;
        }
        if (!speciesRoot.getCombinations(individual.getGenome().getPrimary()).isEmpty()) {
            return;
        }
        this.registerSpecies(individual.getGenome().getPrimary());
    }

    @Override
    public void registerQueen(IIndividual bee) {
        ++this.queensTotal;
    }

    @Override
    public int getQueenCount() {
        return this.queensTotal;
    }

    @Override
    public void registerPrincess(IIndividual bee) {
        ++this.princessesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getPrincessCount() {
        return this.princessesTotal;
    }

    @Override
    public void registerDrone(IIndividual bee) {
        ++this.dronesTotal;
        this.registerBirth(bee);
    }

    @Override
    public int getDroneCount() {
        return this.dronesTotal;
    }

    @Override
    protected IBreedingTracker getBreedingTracker(EntityPlayer player) {
        return BeeManager.beeRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
    }

    @Override
    protected String speciesRootUID() {
        return "rootBees";
    }
}

