/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSparseMinableCluster
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final INumberProvider genClusterSize;
    private final WeightedRandomBlock[] genBlock;

    public WorldGenSparseMinableCluster(ItemStack ore, int clusterSize) {
        this(new WeightedRandomBlock(ore), clusterSize);
    }

    public WorldGenSparseMinableCluster(WeightedRandomBlock resource, int clusterSize) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize);
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> resource, int clusterSize) {
        this(resource, clusterSize, Blocks.field_150348_b);
    }

    public WorldGenSparseMinableCluster(ItemStack ore, int clusterSize, Block block) {
        this(new WeightedRandomBlock(ore, 1), clusterSize, block);
    }

    public WorldGenSparseMinableCluster(WeightedRandomBlock resource, int clusterSize, Block block) {
        this(WorldGenMinableCluster.fabricateList(resource), clusterSize, block);
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, Block block) {
        this(resource, clusterSize, WorldGenMinableCluster.fabricateList(block));
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this(resource, new ConstantProvider(clusterSize), block);
    }

    public WorldGenSparseMinableCluster(List<WeightedRandomBlock> resource, INumberProvider clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.genClusterSize = clusterSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int blocks = MathHelper.func_76125_a((int)this.genClusterSize.intValue(world, rand, pos), (int)1, (int)42);
        float f = rand.nextFloat() * (float)Math.PI;
        float yMin = y + rand.nextInt(3) - 2;
        float yMax = y + rand.nextInt(3) - 2;
        if (blocks == 1 && yMin > yMax) {
            ++blocks;
        }
        if (blocks == 2 && f > 1.5707964f) {
            ++blocks;
        }
        float xMin = (float)x + MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float xMax = (float)x - MathHelper.func_76126_a((float)f) * (float)blocks / 8.0f;
        float zMin = (float)z + MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        float zMax = (float)z - MathHelper.func_76134_b((float)f) * (float)blocks / 8.0f;
        xMax -= xMin;
        yMax -= yMin;
        zMax -= zMin;
        boolean r = false;
        for (int i = 0; i <= blocks; ++i) {
            float xCenter = xMin + xMax * (float)i / (float)blocks;
            float yCenter = yMin + yMax * (float)i / (float)blocks;
            float zCenter = zMin + zMax * (float)i / (float)blocks;
            float size = (float)rand.nextDouble() * (float)blocks / 16.0f;
            float hMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            float vMod = ((MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)blocks)) + 1.0f) * size + 1.0f) * 0.5f;
            int xStart = MathHelper.func_76141_d((float)(xCenter - hMod));
            int yStart = MathHelper.func_76141_d((float)(yCenter - vMod));
            int zStart = MathHelper.func_76141_d((float)(zCenter - hMod));
            int xStop = MathHelper.func_76141_d((float)(xCenter + hMod));
            int yStop = MathHelper.func_76141_d((float)(yCenter + vMod));
            int zStop = MathHelper.func_76141_d((float)(zCenter + hMod));
            for (int blockX = xStart; blockX <= xStop; ++blockX) {
                float xDistSq = ((float)blockX + 0.5f - xCenter) / hMod;
                if ((xDistSq *= xDistSq) >= 1.0f) continue;
                for (int blockY = yStart; blockY <= yStop; ++blockY) {
                    float xyDistSq;
                    float yDistSq = ((float)blockY + 0.5f - yCenter) / vMod;
                    if ((xyDistSq = (yDistSq *= yDistSq) + xDistSq) >= 1.0f) continue;
                    for (int blockZ = zStart; blockZ <= zStop; ++blockZ) {
                        float zDistSq = ((float)blockZ + 0.5f - zCenter) / hMod;
                        if ((zDistSq *= zDistSq) + xyDistSq >= 1.0f) continue;
                        r |= WorldGenMinableCluster.generateBlock(world, blockX, blockY, blockZ, this.genBlock, this.cluster);
                    }
                }
            }
        }
        return r;
    }
}

