/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.parser;

import cofh.cofhworld.feature.generator.FeatureBase;
import cofh.cofhworld.feature.generator.FeatureGenUnderfluid;
import cofh.cofhworld.feature.parser.UniformParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Logger;

public class UnderfluidParser
extends UniformParser {
    private boolean isUnderwater;

    public UnderfluidParser(boolean water) {
        this.isUnderwater = water;
    }

    @Override
    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150346_d, -1), new WeightedRandomBlock((Block)Blocks.field_150349_c, -1));
    }

    @Override
    protected FeatureBase getFeature(String featureName, Config genObject, WorldGenerator gen, INumberProvider numClusters, FeatureBase.GenRestriction biomeRes, boolean retrogen, FeatureBase.GenRestriction dimRes, Logger log) {
        boolean water = true;
        HashSet<String> fluidList = new HashSet<String>();
        if (genObject.hasPath("fluid")) {
            ArrayList<DungeonHooks.DungeonMob> list = new ArrayList<DungeonHooks.DungeonMob>();
            if (FeatureParser.parseWeightedStringList(genObject.root().get("fluid"), list)) {
                water = false;
                for (DungeonHooks.DungeonMob str : list) {
                    Fluid fluid = FluidRegistry.getFluid((String)str.type.func_110623_a());
                    if (fluid == null) continue;
                    fluidList.add(fluid.getName());
                }
            }
        }
        List<WeightedRandomBlock> matList = this.defaultMaterial;
        if (genObject.hasPath("material")) {
            matList = new ArrayList<WeightedRandomBlock>();
            if (!FeatureParser.parseResList(genObject.root().get("material"), matList, false)) {
                log.warn("Invalid material list! Using default list.");
                matList = this.defaultMaterial;
            }
        }
        if (water) {
            return new FeatureGenUnderfluid(featureName, gen, matList, numClusters, biomeRes, retrogen, dimRes);
        }
        return new FeatureGenUnderfluid(featureName, gen, matList, fluidList.toArray(new String[0]), numClusters, biomeRes, retrogen, dimRes);
    }

    @Override
    protected String getDefaultGenerator() {
        return this.isUnderwater ? "plate" : super.getDefaultGenerator();
    }
}

