/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.biome;

import java.util.Collection;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeInfo {
    private final Object data;
    private final boolean whitelist;
    private final int type;
    private final int hash;

    public BiomeInfo(String name) {
        this.data = name;
        this.hash = name.hashCode();
        this.whitelist = true;
        this.type = 0;
    }

    public BiomeInfo(Object d, int t, boolean wl) {
        this.data = d;
        this.hash = 0;
        this.whitelist = wl;
        this.type = t;
    }

    public boolean isBiomeEqual(Biome biome, Random rand) {
        boolean r = false;
        if (biome != null) {
            switch (this.type) {
                default: {
                    break;
                }
                case 0: {
                    String name = biome.func_185359_l();
                    r = name.hashCode() == this.hash && name.equals(this.data);
                    break;
                }
                case 1: {
                    r = biome.func_150561_m() == this.data;
                    break;
                }
                case 2: {
                    r = BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)((BiomeDictionary.Type)this.data));
                    break;
                }
                case 4: {
                    r = ((Collection)this.data).contains(biome.func_185359_l());
                    break;
                }
                case 5: {
                    r = ((Collection)this.data).contains(biome.func_150561_m());
                    break;
                }
                case 6: {
                    BiomeDictionary.Type[] d = (BiomeDictionary.Type[])this.data;
                    int c = 0;
                    int e = d.length;
                    for (int i = 0; i < e; ++i) {
                        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)d[i])) continue;
                        ++c;
                    }
                    r = c == e;
                    break;
                }
                case 7: {
                    ResourceLocation registry = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
                    r = registry.hashCode() == this.hash && registry.equals(this.data);
                    break;
                }
                case 8: {
                    r = ((Collection)this.data).contains(Biome.field_185377_q.func_177774_c((Object)biome));
                }
            }
        }
        return r == this.whitelist;
    }
}

