/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import codechicken.lib.texture.TextureDataHolder;
import codechicken.lib.texture.TextureSpecial;
import codechicken.lib.texture.TextureUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class TextureOverlay {
    public static final String PATH_BASE = "thermaldynamics:textures/blocks/duct/base/";
    public static final String PATH_CONNECTION = "thermaldynamics:textures/blocks/duct/connection/";
    public static final String PATH_FRAME = "thermaldynamics:textures/blocks/duct/base/";

    public static ResourceLocation toLoc(String path, String name) {
        return new ResourceLocation(path + name + ".png");
    }

    public static TextureDataHolder incSize(TextureDataHolder tex, int newWidth) {
        int n = newWidth / tex.width;
        TextureDataHolder newTex = new TextureDataHolder(newWidth, tex.height * n);
        for (int i = 0; i < newTex.data.length; ++i) {
            newTex.data[i] = -1737058186;
        }
        for (int x = 0; x < tex.width; ++x) {
            for (int y = 0; y < tex.height; ++y) {
                int col = tex.data[x + y * tex.width];
                for (int dx = 0; dx < n; ++dx) {
                    for (int dy = 0; dy < n; ++dy) {
                        newTex.data[x * n + dx + (y * n + dy) * newTex.width] = col;
                    }
                }
            }
        }
        return newTex;
    }

    public static TextureAtlasSprite generateBaseTexture(TextureMap map, String base, String ... textures) {
        TextureDataHolder image = TextureUtils.loadTexture((ResourceLocation)TextureOverlay.toLoc("thermaldynamics:textures/blocks/duct/base/", base));
        StringBuilder builder = new StringBuilder("thermaldynamics:duct_").append(base);
        for (String texture : textures) {
            if (texture == null) continue;
            builder.append('_').append(texture);
        }
        String name = builder.toString();
        TextureAtlasSprite entry = map.getTextureExtry(name);
        if (entry != null) {
            return entry;
        }
        for (String texture : textures) {
            int j;
            if (texture == null) continue;
            TextureDataHolder newimage = TextureUtils.loadTexture((ResourceLocation)TextureOverlay.toLoc("thermaldynamics:textures/blocks/duct/base/", texture));
            if (image.width != newimage.width) {
                if (image.width < newimage.width) {
                    image = TextureOverlay.incSize(image, newimage.width);
                } else {
                    newimage = TextureOverlay.incSize(newimage, image.width);
                }
            }
            if ("trans".equals(texture)) {
                for (j = 0; j < newimage.data.length; ++j) {
                    if ((newimage.data[j] >> 24 & 0xFF) == 0) continue;
                    image.data[j] = 0;
                }
                continue;
            }
            for (j = 0; j < newimage.data.length; ++j) {
                int colour = newimage.data[j];
                if ((colour >> 24 & 0xFF) == 0) continue;
                image.data[j] = colour;
            }
        }
        TextureSpecial texture = TextureUtils.getTextureSpecial((TextureMap)map, (String)name);
        texture.addTexture(image);
        return texture;
    }

    public static TextureAtlasSprite generateConnectionTexture(TextureMap map, String connection) {
        TextureDataHolder image = TextureUtils.loadTexture((ResourceLocation)TextureOverlay.toLoc(PATH_CONNECTION, connection));
        String name = "thermaldynamics:conn_" + connection;
        TextureAtlasSprite entry = map.getTextureExtry(name);
        if (entry != null) {
            return entry;
        }
        TextureSpecial texture = TextureUtils.getTextureSpecial((TextureMap)map, (String)name);
        texture.addTexture(image);
        return texture;
    }

    public static TextureAtlasSprite generateFrameTexture(TextureMap map, String frame) {
        TextureDataHolder image = TextureUtils.loadTexture((ResourceLocation)TextureOverlay.toLoc("thermaldynamics:textures/blocks/duct/base/", frame + "_trans"));
        String name = "thermaldynamics:frame_" + frame;
        TextureAtlasSprite entry = map.getTextureExtry(name);
        if (entry != null) {
            return entry;
        }
        TextureSpecial texture = TextureUtils.getTextureSpecial((TextureMap)map, (String)name);
        texture.addTexture(image);
        return texture;
    }

    public static TextureAtlasSprite generateFrameBandTexture(TextureMap register, String frame) {
        TextureDataHolder image = TextureUtils.loadTexture((ResourceLocation)TextureOverlay.toLoc("thermaldynamics:textures/blocks/duct/base/", frame + "_band"));
        String name = "thermaldynamics:band_" + frame;
        TextureAtlasSprite entry = register.getTextureExtry(name);
        if (entry != null) {
            return entry;
        }
        TextureSpecial texture = TextureUtils.getTextureSpecial((TextureMap)register, (String)name);
        texture.addTexture(image);
        return texture;
    }
}

